/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.FieldMemoryStats;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsAccounting;
import org.elasticsearch.index.shard.ShardId;

public class ShardFieldData
implements IndexFieldDataCache.Listener {
    private final CounterMetric evictionsMetric = new CounterMetric();
    private final CounterMetric totalMetric = new CounterMetric();
    private final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();
    private final CounterMetric buildTime = new CounterMetric();
    private final ConcurrentMap<String, GlobalOrdinalFieldStats> perFieldGlobalOrdinalStats = ConcurrentCollections.newConcurrentMap();

    public FieldDataStats stats(String ... fields) {
        HashMap<String, Long> fieldTotals = null;
        HashMap<String, FieldDataStats.GlobalOrdinalsStats.GlobalOrdinalFieldStats> fieldGlobalOrdinalsStats = null;
        if (!CollectionUtils.isEmpty(fields)) {
            fieldTotals = new HashMap<String, Long>();
            for (Map.Entry entry : this.perFieldTotals.entrySet()) {
                if (!Regex.simpleMatch(fields, (String)entry.getKey())) continue;
                fieldTotals.put((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
            }
            for (Map.Entry entry : this.perFieldGlobalOrdinalStats.entrySet()) {
                if (!Regex.simpleMatch(fields, (String)entry.getKey())) continue;
                if (fieldGlobalOrdinalsStats == null) {
                    fieldGlobalOrdinalsStats = new HashMap<String, FieldDataStats.GlobalOrdinalsStats.GlobalOrdinalFieldStats>();
                }
                fieldGlobalOrdinalsStats.put((String)entry.getKey(), new FieldDataStats.GlobalOrdinalsStats.GlobalOrdinalFieldStats(((GlobalOrdinalFieldStats)entry.getValue()).totalBuildTime.count(), ((GlobalOrdinalFieldStats)entry.getValue()).valueCount.get()));
            }
        }
        return new FieldDataStats(this.totalMetric.count(), this.evictionsMetric.count(), fieldTotals == null ? null : new FieldMemoryStats(fieldTotals), new FieldDataStats.GlobalOrdinalsStats(this.buildTime.count(), fieldGlobalOrdinalsStats));
    }

    @Override
    public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
        this.totalMetric.inc(ramUsage.ramBytesUsed());
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
        if (total != null) {
            total.inc(ramUsage.ramBytesUsed());
        } else {
            total = new CounterMetric();
            total.inc(ramUsage.ramBytesUsed());
            CounterMetric prev = this.perFieldTotals.putIfAbsent(fieldName, total);
            if (prev != null) {
                prev.inc(ramUsage.ramBytesUsed());
            }
        }
    }

    @Override
    public void onCache(ShardId shardId, String fieldName, GlobalOrdinalsAccounting info) {
        this.buildTime.inc(info.getBuildingTime().millis());
        this.perFieldGlobalOrdinalStats.compute(fieldName, (f, globalOrdinalFieldStats) -> {
            if (globalOrdinalFieldStats == null) {
                globalOrdinalFieldStats = new GlobalOrdinalFieldStats();
            }
            globalOrdinalFieldStats.totalBuildTime.inc(info.getBuildingTime().millis());
            if (globalOrdinalFieldStats.valueCount.get() < info.getValueCount()) {
                globalOrdinalFieldStats.valueCount.set(info.getValueCount());
            }
            return globalOrdinalFieldStats;
        });
    }

    @Override
    public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes != -1L) {
            this.totalMetric.dec(sizeInBytes);
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
            if (total != null) {
                total.dec(sizeInBytes);
            }
        }
    }

    static class GlobalOrdinalFieldStats {
        private final CounterMetric totalBuildTime = new CounterMetric();
        private final AtomicLong valueCount = new AtomicLong();

        GlobalOrdinalFieldStats() {
        }
    }
}

