/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.TranslogOperationAsserter;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.elasticsearch.index.translog.TranslogStats;

public final class NoOpEngine
extends ReadOnlyEngine {
    private final SegmentsStats segmentsStats = new SegmentsStats();
    private final DocsStats docsStats;

    public NoOpEngine(EngineConfig config) {
        this(config, (TranslogStats)(config.isPromotableToPrimary() && config.getTranslogConfig().hasTranslog() ? null : new TranslogStats(0, 0L, 0, 0L, 0L)), config.isPromotableToPrimary() ? null : new SeqNoStats(config.getGlobalCheckpointSupplier().getAsLong(), config.getGlobalCheckpointSupplier().getAsLong(), config.getGlobalCheckpointSupplier().getAsLong()));
    }

    public NoOpEngine(EngineConfig config, @Nullable TranslogStats translogStats, SeqNoStats seqNoStats) {
        super(config, seqNoStats, translogStats, true, Function.identity(), true, true);
        Directory directory = this.store.directory();
        try (DirectoryReader reader = this.openDirectory(directory);){
            for (LeafReaderContext ctx : reader.getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, true, this.segmentsStats);
            }
            this.docsStats = this.docsStats(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected DirectoryReader open(IndexCommit commit) throws IOException {
        Directory directory = commit.getDirectory();
        List<IndexCommit> indexCommits = DirectoryReader.listCommits(directory);
        final IndexCommit indexCommit = indexCommits.get(indexCommits.size() - 1);
        return new DirectoryReader(this, directory, new LeafReader[0], null){

            @Override
            protected DirectoryReader doOpenIfChanged() {
                return null;
            }

            @Override
            protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
                return null;
            }

            @Override
            protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
                return null;
            }

            @Override
            public long getVersion() {
                return 0L;
            }

            @Override
            public boolean isCurrent() {
                return true;
            }

            @Override
            public IndexCommit getIndexCommit() {
                return indexCommit;
            }

            @Override
            protected void doClose() {
            }

            @Override
            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    @Override
    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        if (includeUnloadedSegments) {
            SegmentsStats stats = new SegmentsStats();
            stats.add(this.segmentsStats);
            if (!includeSegmentFileSizes) {
                stats.clearFiles();
            }
            return stats;
        }
        return super.segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
    }

    @Override
    public DocsStats docStats() {
        return this.docsStats;
    }

    @Override
    public void trimUnreferencedTranslogFiles() {
        block20: {
            Store store = this.engineConfig.getStore();
            store.incRef();
            try (Releasable ignored = this.acquireEnsureOpenRef();){
                List<IndexCommit> commits = DirectoryReader.listCommits(store.directory());
                if (commits.size() != 1 || this.translogStats.getTranslogSizeInBytes() <= this.translogStats.getUncommittedSizeInBytes()) break block20;
                Map<String, String> commitUserData = this.getLastCommittedSegmentInfos().getUserData();
                String translogUuid = commitUserData.get("translog_uuid");
                if (translogUuid == null) {
                    throw new IllegalStateException("commit doesn't contain translog unique id");
                }
                TranslogConfig translogConfig = this.engineConfig.getTranslogConfig();
                long localCheckpoint = Long.parseLong(commitUserData.get("local_checkpoint"));
                TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy();
                translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpoint);
                try (Translog translog = new Translog(translogConfig, translogUuid, translogDeletionPolicy, this.engineConfig.getGlobalCheckpointSupplier(), this.engineConfig.getPrimaryTermSupplier(), seqNo -> {}, TranslogOperationAsserter.DEFAULT);){
                    translog.trimUnreferencedReaders();
                    this.translogStats = translog.stats();
                    assert (translog.currentFileGeneration() == translog.getMinFileGeneration()) : "translog was not trimmed  current gen " + translog.currentFileGeneration() + " != min gen " + translog.getMinFileGeneration();
                }
            }
            catch (Exception e) {
                try {
                    this.failEngine("translog trimming failed", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new EngineException(this.shardId, "failed to trim translog", e, new Object[0]);
            }
            finally {
                store.decRef();
            }
        }
    }
}

