/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.elasticsearch.indices.recovery.FileDetails;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RecoveryFiles
implements JsonpSerializable {
    private final List<FileDetails> details;
    private final String percent;
    private final long recovered;
    private final long reused;
    private final long total;
    public static final JsonpDeserializer<RecoveryFiles> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryFiles::setupRecoveryFilesDeserializer);

    private RecoveryFiles(Builder builder) {
        this.details = ApiTypeHelper.unmodifiable(builder.details);
        this.percent = ApiTypeHelper.requireNonNull(builder.percent, this, "percent");
        this.recovered = ApiTypeHelper.requireNonNull(builder.recovered, (Object)this, "recovered", 0L);
        this.reused = ApiTypeHelper.requireNonNull(builder.reused, (Object)this, "reused", 0L);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
    }

    public static RecoveryFiles of(Function<Builder, ObjectBuilder<RecoveryFiles>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FileDetails> details() {
        return this.details;
    }

    public final String percent() {
        return this.percent;
    }

    public final long recovered() {
        return this.recovered;
    }

    public final long reused() {
        return this.reused;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (FileDetails item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("percent");
        generator.write(this.percent);
        generator.writeKey("recovered");
        generator.write(this.recovered);
        generator.writeKey("reused");
        generator.write(this.reused);
        generator.writeKey("total");
        generator.write(this.total);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRecoveryFilesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(FileDetails._DESERIALIZER), "details");
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent");
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered");
        op.add(Builder::reused, JsonpDeserializer.longDeserializer(), "reused");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RecoveryFiles> {
        @Nullable
        private List<FileDetails> details;
        private String percent;
        private Long recovered;
        private Long reused;
        private Long total;

        public final Builder details(List<FileDetails> list) {
            this.details = Builder._listAddAll(this.details, list);
            return this;
        }

        public final Builder details(FileDetails value, FileDetails ... values) {
            this.details = Builder._listAdd(this.details, value, values);
            return this;
        }

        public final Builder details(Function<FileDetails.Builder, ObjectBuilder<FileDetails>> fn) {
            return this.details(fn.apply(new FileDetails.Builder()).build(), new FileDetails[0]);
        }

        public final Builder percent(String value) {
            this.percent = value;
            return this;
        }

        public final Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        public final Builder reused(long value) {
            this.reused = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RecoveryFiles build() {
            this._checkSingleUse();
            return new RecoveryFiles(this);
        }
    }
}

