"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _color_row = require("./color_row");
var _default = require("../default/default");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ColorFormatEditor extends _default.DefaultFormatEditor {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onColorChange", (newColorParams, index) => {
      const colors = [...this.props.formatParams.colors];
      colors[index] = {
        ...colors[index],
        ...newColorParams
      };
      this.onChange({
        colors
      });
    });
    (0, _defineProperty2.default)(this, "addColor", () => {
      const colors = [...(this.props.formatParams.colors || [])];
      this.onChange({
        colors: [...colors, {
          ..._common.DEFAULT_CONVERTER_COLOR
        }]
      });
    });
    (0, _defineProperty2.default)(this, "removeColor", index => {
      const colors = [...this.props.formatParams.colors];
      colors.splice(index, 1);
      this.onChange({
        colors
      });
    });
    this.onChange({
      fieldType: props.fieldType // FIXME: why add `fieldType` as an EditorFormatParam?
    });
  }
  render() {
    const {
      formatParams,
      fieldType
    } = this.props;
    const colors = formatParams === null || formatParams === void 0 ? void 0 : formatParams.colors;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.color.colorFormatterTitle",
      defaultMessage: "Color formatting"
    }))), (colors === null || colors === void 0 ? void 0 : colors.length) > 0 && colors.map((color, index) => {
      return /*#__PURE__*/_react.default.createElement(_color_row.ColorRow, {
        key: index,
        fieldType: fieldType,
        color: color,
        index: index,
        onColorChange: this.onColorChange,
        onRemoveColor: this.removeColor,
        showDeleteButton: (colors === null || colors === void 0 ? void 0 : colors.length) > 1
      });
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      size: "s",
      onClick: this.addColor,
      "data-test-subj": "colorEditorAddColor"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.color.addColorButton",
      defaultMessage: "Add color"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }
}
exports.ColorFormatEditor = ColorFormatEditor;
(0, _defineProperty2.default)(ColorFormatEditor, "formatId", _constants.formatId);