"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForIndexStatus = waitForIndexStatus;
var Either = _interopRequireWildcard(require("fp-ts/Either"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/**
 * Wait until an index status become either 'yellow' or 'green'.
 *
 * A yellow index status means the index's primary shard was allocated but ES
 * wasn't able to allocate the replica. Thus a yellow index can be searched
 * and read from but indexing documents with `wait_for_active_shards='all'`
 * will fail.
 *
 * A green index status means the index's primary and replica shards has been
 * allocated so we can search, read and index documents with
 * `wait_for_active_shards='all'`.
 */
function waitForIndexStatus({
  client,
  index,
  timeout = _constants.DEFAULT_TIMEOUT,
  status
}) {
  return () => {
    return client.cluster.health({
      index,
      wait_for_status: status,
      timeout
    }, {
      /* Don't reject on status code 408 so that we can handle the timeout
       * explicitly with a custom response type and provide more context in the error message
       */
      ignore: [408]
    }).then(res => {
      if (res.timed_out === true) {
        return Either.left({
          type: `index_not_${status}_timeout`,
          message: `[index_not_${status}_timeout] Timeout waiting for the status of the [${index}] index to become '${status}'`
        });
      }
      return Either.right({});
    }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
  };
}