"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPopoverButton = TimeSliderPopoverButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const timeSliderStyles = {
  anchor: ({
    euiTheme
  }) => (0, _react2.css)`
    width: 100%;
    height: 100%;
    box-shadow: none;
    overflow: hidden;

    .euiText {
      &:hover {
        text-decoration: underline;
      }

      &:not(.euiFormControlLayoutDelimited__delimiter) {
        cursor: pointer !important;
      }
    }

    .timeSlider__anchorText {
      font-weight: ${euiTheme.font.weight.medium};
    }

    .timeSlider__anchorText--default {
      color: ${euiTheme.colors.mediumShade};
    }

    .timeSlider__anchorText--invalid {
      text-decoration: line-through;
      color: ${euiTheme.colors.mediumShade};
    }

    &:focus-visible {
      outline-offset: -3px;
    }
  `
};
function TimeSliderPopoverButton(props) {
  const styles = (0, _use_memo_css.useMemoCss)(timeSliderStyles);
  return /*#__PURE__*/_react.default.createElement("button", {
    className: "eui-textTruncate",
    color: "text",
    onClick: props.onClick,
    "data-test-subj": "timeSlider-popoverToggleButton",
    css: styles.anchor
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "timeSlider__anchorText eui-textTruncate",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, props.formatDate(props.from)), "\xA0\xA0\u2192\xA0\xA0", /*#__PURE__*/_react.default.createElement("span", null, props.formatDate(props.to))));
}