"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigurationTable = AgentConfigurationTable;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConfigurationValueColumn({
  columnKey,
  value,
  createApiKey,
  createApiKeyLoading
}) {
  const shouldRenderCreateApiKeyButton = columnKey === 'apiKey' && value === null;
  if (shouldRenderCreateApiKeyButton) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "createApiKeyAndId",
      fill: true,
      onClick: createApiKey,
      isLoading: createApiKeyLoading
    }, _i18n.i18n.translate('xpack.apm.tutorial.apiKey.create', {
      defaultMessage: 'Create API Key'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "accent"
  }, value), value && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "apmConfigurationValueColumnButton",
    "aria-label": _i18n.i18n.translate('xpack.apm.onboarding.column.value.copyIconText', {
      defaultMessage: 'Copy to clipboard'
    }),
    color: "text",
    iconType: "copy",
    onClick: () => (0, _eui.copyToClipboard)(value)
  }));
}
function AgentConfigurationTable({
  variables,
  data,
  createApiKey,
  createApiKeyLoading
}) {
  if (!variables) return null;
  const defaultValues = {
    apmServiceName: 'my-service-name',
    apmEnvironment: 'my-environment'
  };
  const columns = [{
    field: 'setting',
    name: _i18n.i18n.translate('xpack.apm.onboarding.agent.column.configSettings', {
      defaultMessage: 'Configuration setting'
    })
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.apm.onboarding.agent.column.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value,
      key
    }) => /*#__PURE__*/_react.default.createElement(ConfigurationValueColumn, {
      columnKey: key,
      value: value,
      createApiKey: createApiKey,
      createApiKeyLoading: createApiKeyLoading
    })
  }];
  const items = Object.entries(variables).map(([key, value]) => ({
    setting: value,
    value: (0, _lodash.get)({
      ...data,
      ...defaultValues
    }, key),
    key
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns
  });
}