"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _index = require("./index");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var ComboBox = function ComboBox() {
  var _useState = (0, _react.useState)([{
      label: 'Titan',
      'data-test-subj': 'titanOption'
    }, {
      label: 'Enceladus',
      'data-test-subj': 'enceladusOption'
    }, {
      label: 'Mimas',
      'data-test-subj': 'mimasOption'
    }, {
      label: 'Dione',
      'data-test-subj': 'dioneOption'
    }, {
      label: 'Iapetus',
      'data-test-subj': 'iapetusOption'
    }, {
      label: 'Phoebe',
      'data-test-subj': 'phoebeOption'
    }, {
      label: 'Rhea',
      'data-test-subj': 'rheaOption'
    }, {
      label: 'Tethys',
      'data-test-subj': 'tethysOption'
    }, {
      label: 'Hyperion',
      'data-test-subj': 'hyperionOption'
    }]),
    _useState2 = _slicedToArray(_useState, 1),
    options = _useState2[0];
  var _useState3 = (0, _react.useState)([]),
    _useState4 = _slicedToArray(_useState3, 2),
    selectedOptions = _useState4[0],
    setSelected = _useState4[1];
  var onChange = function onChange(selectedOptions) {
    setSelected(selectedOptions);
  };
  return (0, _react2.jsx)(_index.EuiComboBox, {
    "aria-label": "Accessible screen reader label",
    placeholder: "Select options",
    options: options,
    selectedOptions: selectedOptions,
    onChange: onChange,
    isClearable: true,
    isCaseSensitive: true
  });
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(ComboBox, null));
  cy.get('input[data-test-subj="comboBoxSearchInput"]').should('exist');
});
describe('EuiComboBox', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the combobox is expanded', function () {
      cy.get('input[data-test-subj="comboBoxSearchInput"]').realClick();
      cy.get('button[data-test-subj="titanOption"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.realPress('Tab');
      cy.get('input[data-test-subj="comboBoxSearchInput"]').should('have.focus');
      cy.get('button[data-test-subj="titanOption"]').should('exist');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('Enter');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('Enter');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('Enter');
      cy.get('div[data-test-subj="comboBoxInput"]').find('span.euiBadge').should('have.length', 3);
      cy.checkAxe();

      // Close the listbox and interact with the Clear button
      cy.realPress('Escape');
      cy.realPress('Tab');
      cy.get('button[data-test-subj="comboBoxClearButton"]').should('have.focus');
      cy.realPress('Space');
      cy.get('div[data-test-subj="comboBoxInput"]').find('span.euiBadge').should('have.length', 0);
      cy.checkAxe();
    });
  });
});