"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegendStrategy = void 0;
exports.highlightedGeoms = highlightedGeoms;
const legendStrategies = {
    node: (legendPath) => ({ path }) => legendPath.length === path.length &&
        legendPath.every(({ index, value }, i) => index === path[i]?.index && value === path[i]?.value),
    path: (legendPath) => ({ path }) => path.every(({ index, value }, i) => index === legendPath[i]?.index && value === legendPath[i]?.value),
    keyInLayer: (legendPath) => ({ path, dataName }) => legendPath.length === path.length && dataName === legendPath.at(-1)?.value,
    key: (legendPath) => ({ dataName }) => dataName === legendPath.at(-1)?.value,
    nodeWithDescendants: (legendPath) => ({ path }) => legendPath.every(({ index, value }, i) => index === path[i]?.index && value === path[i]?.value),
    pathWithDescendants: (legendPath) => ({ path }) => legendPath
        .slice(0, path.length)
        .every(({ index, value }, i) => index === path[i]?.index && value === path[i]?.value),
};
exports.LegendStrategy = Object.freeze({
    Node: 'node',
    Path: 'path',
    KeyInLayer: 'keyInLayer',
    Key: 'key',
    NodeWithDescendants: 'nodeWithDescendants',
    PathWithDescendants: 'pathWithDescendants',
});
const defaultStrategy = exports.LegendStrategy.Path;
function highlightedGeoms(legendStrategy, flatLegend, quadViewModel, highlightedLegendItemPath) {
    return quadViewModel.filter(legendStrategies[legendStrategy ?? defaultStrategy](highlightedLegendItemPath));
}
//# sourceMappingURL=highlighted_geoms.js.map