"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskLevelsTableColumns = exports.useRiskLevelsPrivilegedUserQuery = void 0;
var _react = _interopRequireWildcard(require("react"));
var _esqlUtils = require("@kbn/esql-utils");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_risk_engine_status = require("../../../../api/hooks/use_risk_engine_status");
var _use_error_toast = require("../../../../../common/hooks/use_error_toast");
var _use_esql_global_filter = require("../../../../../common/hooks/esql/use_esql_global_filter");
var _kibana = require("../../../../../common/lib/kibana");
var _use_get_default_risk_index = require("../../../../hooks/use_get_default_risk_index");
var _common = require("../../../severity/common");
var _esql = require("../../../../../common/utils/esql");
var _risk_level_esql_query = require("../../queries/risk_level_esql_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskLevelsPrivilegedUserQuery = ({
  skip,
  spaceId
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const index = (0, _use_get_default_risk_index.useGetDefaultRiskIndex)(true); // only latest
  const filterQuery = (0, _use_esql_global_filter.useEsqlGlobalFilterQuery)();
  const query = `FROM ${index} ${(0, _risk_level_esql_query.getRiskLevelsPrivilegedUsersQueryBody)(spaceId)}`;
  const {
    data: riskEngineStatus,
    isFetching: isStatusLoading,
    refetch: refetchEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const {
    isRefetching,
    data: result,
    error,
    isError,
    refetch
  } = (0, _reactQuery.useQuery)([],
  // query doesn't need a key since it is only run when refetch is called
  async ({
    signal
  }) => (0, _esqlUtils.getESQLResults)({
    esqlQuery: query,
    search: data.search.search,
    signal,
    filter: filterQuery
  }), {
    keepPreviousData: true,
    enabled: false,
    retry: 1 // retry once on failure
  });

  // Hide unknown index errors from UI because they index might take some time to be created
  const filteredError = error && !error.message.includes('Unknown index') ? error : undefined;
  (0, _use_error_toast.useErrorToast)(_i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.riskLevels.queryError', {
    defaultMessage: 'There was an error loading the data'
  }), filteredError);
  const response = result === null || result === void 0 ? void 0 : result.response;
  const inspect = (0, _react.useMemo)(() => {
    return {
      dsl: [JSON.stringify({
        index: index ? [index] : [''],
        body: (0, _esqlUtils.prettifyQuery)(query, false)
      }, null, 2)],
      response: response ? [JSON.stringify(response, null, 2)] : []
    };
  }, [index, query, response]);

  // Fetch risk score when components mounts or when the risk engine status changes
  (0, _react.useEffect)(() => {
    if (!skip && !isStatusLoading && (riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status) !== 'NOT_INSTALLED') {
      refetch();
    }
  }, [riskEngineStatus, isStatusLoading, refetch, skip]);
  return {
    records: (0, _esql.esqlResponseToRecords)(response),
    isLoading: isRefetching || isStatusLoading,
    refetch: refetchEngineStatus,
    // refetching the status will force the risk score to be fetched,
    inspect,
    error,
    isRefetching,
    isError,
    hasEngineBeenInstalled: (riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status) !== 'NOT_INSTALLED'
  };
};
exports.useRiskLevelsPrivilegedUserQuery = useRiskLevelsPrivilegedUserQuery;
const useRiskLevelsTableColumns = () => {
  return (0, _react.useMemo)(() => [{
    field: 'level',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.riskLevels.riskLevelColumn",
      defaultMessage: "Risk level"
    }),
    truncateText: true,
    render: level => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      hideBackgroundColor: true,
      severity: level
    }))
  }, {
    field: 'count',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.riskLevels.numberOfUsersColumn",
      defaultMessage: "Number of users"
    }),
    dataType: 'number'
  }, {
    field: 'percentage',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.riskLevels.percentageColumn",
      defaultMessage: "% of users"
    }),
    align: 'right',
    render: percentage => `${Math.round(percentage)}%`
  }], []);
};
exports.useRiskLevelsTableColumns = useRiskLevelsTableColumns;