"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUsersTable = exports.PRIVILEGED_USERS_TABLE_QUERY_ID = exports.DEFAULT_PAGE_SIZE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18n = require("@kbn/i18n");
var _inspect = require("../../../../../common/components/inspect");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _manage_query = require("../../../../../common/components/page/manage_query");
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _constants = require("../../../../../flyout/entity_details/shared/constants");
var _columns = require("./columns");
var _header_section = require("../../../../../common/components/header_section");
var _hooks = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = exports.DEFAULT_PAGE_SIZE = 10;
const PRIVILEGED_USERS_TABLE_QUERY_ID = exports.PRIVILEGED_USERS_TABLE_QUERY_ID = 'privmonPrivilegedUsersTableQueryId';
const TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.title', {
  defaultMessage: 'Privileged users'
});
const PRIVILEGED_USERS_TABLE_ID = 'PrivilegedUsers-table';
const useOpenUserFlyout = () => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  return userName => {
    openFlyout({
      right: {
        id: _constants.UserPanelKey,
        params: {
          contextID: PRIVILEGED_USERS_TABLE_ID,
          userName,
          scopeId: PRIVILEGED_USERS_TABLE_ID
        }
      }
    });
  };
};
const PrivilegedUsersTable = ({
  spaceId
}) => {
  const {
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(PRIVILEGED_USERS_TABLE_QUERY_ID);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const openUserFlyout = useOpenUserFlyout();
  const columns = (0, _columns.buildPrivilegedUsersTableColumns)(openUserFlyout, euiTheme);
  const [currentPage, setCurrentPage] = (0, _react.useState)(1);
  const {
    visibleRecords,
    isLoading,
    hasError,
    refetch,
    inspect,
    hasNextPage
  } = (0, _hooks.usePrivilegedUsersTableData)(spaceId, currentPage, toggleStatus);
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: PRIVILEGED_USERS_TABLE_QUERY_ID,
    loading: isLoading
  });
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "privileged-users-table-panel"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    id: PRIVILEGED_USERS_TABLE_QUERY_ID,
    title: TITLE,
    titleSize: "s",
    outerDirection: "column",
    hideSubtitle: true
  }), hasError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.error', {
      defaultMessage: 'There was an error retrieving privileged users. Results may be incomplete.'
    }),
    color: "danger",
    iconType: "error"
  }), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent"
  })), visibleRecords.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.showing",
    defaultMessage: "Showing "
  }), /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
                      font-weight: ${euiTheme.font.weight.bold};
                    `
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.countOfUsers",
    defaultMessage: "{count} privileged {count, plural, one {user} other {users}}",
    values: {
      count: visibleRecords.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    css: {
      height: 2
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    id: PRIVILEGED_USERS_TABLE_QUERY_ID,
    loading: isLoading,
    items: visibleRecords || [],
    columns: columns
  })) : !isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.noData",
    defaultMessage: "No privileged users found"
  })), hasNextPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isLoading,
    onClick: () => {
      setCurrentPage(page => page + 1);
    },
    flush: "right",
    color: "primary",
    size: "s",
    iconType: "sortDown",
    iconSide: "right",
    iconSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.privilegedUserMonitoring.showMore",
    defaultMessage: "Show more"
  }))))));
};
exports.PrivilegedUsersTable = PrivilegedUsersTable;