"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionsPanel = exports.PRIVILEGED_ACCESS_DETECTIONS_QUERY_ID = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@kbn/react-query");
var _i18nReact = require("@kbn/i18n-react");
var _inspect = require("../../../../../common/components/inspect");
var _pad_ml_popover = require("./pad_ml_popover");
var _header_section = require("../../../../../common/components/header_section");
var _constants = require("../privileged_user_activity/constants");
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _pad_chart = require("./pad_chart");
var _pad_routes = require("./pad_routes");
var _pad_install_prompt = require("./pad_install_prompt");
var _pad_view_all_anomalies_button = require("./pad_view_all_anomalies_button");
var _info_popover = require("./info_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVILEGED_ACCESS_DETECTIONS_QUERY_ID = exports.PRIVILEGED_ACCESS_DETECTIONS_QUERY_ID = 'privileged-access-detection-query';
const PRIVILEGED_ACCESS_DETECTIONS_STATUS_REFRESH_INTERVAL_IN_MS = 10_000;
const PrivilegedAccessDetectionsPanel = ({
  spaceId
}) => {
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(_constants.PRIVILEGED_USER_ACTIVITY_QUERY_ID);
  const {
    getPrivilegedAccessDetectionStatus,
    setupPrivilegedAccessDetectionMlModule,
    installPrivilegedAccessDetectionPackage
  } = (0, _pad_routes.usePrivilegedAccessDetectionRoutes)();
  const {
    data: padInstallationStatus,
    error: padInstallationStatusError,
    refetch: refetchInstallationStatus
  } = (0, _reactQuery.useQuery)(['padInstallationStatus'], getPrivilegedAccessDetectionStatus, {
    refetchInterval: PRIVILEGED_ACCESS_DETECTIONS_STATUS_REFRESH_INTERVAL_IN_MS
  });
  const setupMlModuleMutation = (0, _reactQuery.useMutation)({
    mutationFn: setupPrivilegedAccessDetectionMlModule
  });
  const installPrivilegedAccessDetectionPackageMutation = (0, _reactQuery.useMutation)({
    mutationFn: installPrivilegedAccessDetectionPackage
  });
  const currentlyInstalling = installPrivilegedAccessDetectionPackageMutation.isLoading || setupMlModuleMutation.isLoading;
  const install = async () => {
    await installPrivilegedAccessDetectionPackageMutation.mutateAsync();
    await setupMlModuleMutation.mutateAsync();
    await refetchInstallationStatus();
  };
  const packageInstallationComplete = (padInstallationStatus === null || padInstallationStatus === void 0 ? void 0 : padInstallationStatus.package_installation_status) === 'complete' && (padInstallationStatus === null || padInstallationStatus === void 0 ? void 0 : padInstallationStatus.ml_module_setup_status) === 'complete';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, padInstallationStatusError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.errorStatus', {
      defaultMessage: 'There was an error retrieving the status of the privileged access detection package.'
    }),
    color: "danger",
    iconType: "error"
  }), !padInstallationStatus && !padInstallationStatusError && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": 'pad-loading-status',
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent"
  })), padInstallationStatus && !packageInstallationComplete && !currentlyInstalling && /*#__PURE__*/_react.default.createElement(_pad_install_prompt.PrivilegedAccessDetectionInstallPrompt, {
    installationErrorOccurred: !!installPrivilegedAccessDetectionPackageMutation.error || !!setupMlModuleMutation.error,
    install: install
  }), currentlyInstalling && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasBorder: false,
    iconType: "logoSecurity",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetectionAnomalies.privilegedAccessDetection', {
      defaultMessage: 'Privileged access detection'
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetectionAnomalies.installingPrivilegedAccessDetection', {
      defaultMessage: 'Installing Privileged access detection package'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "s",
      color: "accent"
    }))
  }))), packageInstallationComplete && /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "privileged-access-detections-panel"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    id: PRIVILEGED_ACCESS_DETECTIONS_QUERY_ID,
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.topPrivilegedAccessDetectionAnomalies.title",
      defaultMessage: "Top privileged access anomalies"
    }), /*#__PURE__*/_react.default.createElement(_info_popover.PrivilegedAccessInfoPopover, null)),
    titleSize: "s",
    outerDirection: "column",
    hideSubtitle: true
  }, toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_pad_ml_popover.PrivilegedAccessDetectionMLPopover, null), /*#__PURE__*/_react.default.createElement(_pad_view_all_anomalies_button.PrivilegedAccessDetectionViewAllAnomaliesButton, null))), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_pad_chart.PrivilegedAccessDetectionChart, {
    jobIds: padInstallationStatus.jobs.map(eachJob => eachJob.job_id),
    spaceId: spaceId
  })))));
};
exports.PrivilegedAccessDetectionsPanel = PrivilegedAccessDetectionsPanel;