"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupedSubLevelComponent = exports.GroupedSubLevel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _esQuery = require("@kbn/es-query");
var _grouping = require("@kbn/grouping");
var _common = require("@kbn/data-plugin/common");
var _src = require("@kbn/grouping/src");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _model = require("../../../sourcerer/store/model");
var _kuery = require("../../../common/lib/kuery");
var _inspect = require("../../../common/components/inspect");
var _containers = require("../../../sourcerer/containers");
var _kibana = require("../../../common/lib/kibana");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _hooks = require("../alerts_kpis/common/hooks");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_query = require("../../containers/detection_engine/alerts/use_query");
var _constants = require("../../containers/detection_engine/alerts/constants");
var _grouping_settings = require("./grouping_settings");
var _use_browser_fields = require("../../../data_view_manager/hooks/use_browser_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_GROUPING_ID = 'alerts-grouping';
const DEFAULT_FILTERS = [];
const GroupedSubLevelComponent = ({
  defaultFilters = DEFAULT_FILTERS,
  from,
  getGrouping,
  globalFilters,
  globalQuery,
  groupingLevel,
  groupStatsAggregations,
  groupTakeActionItems,
  loading,
  onGroupClose,
  pageIndex,
  pageSize,
  parentGroupingFilter,
  renderChildComponent,
  runtimeMappings,
  selectedGroup,
  setPageIndex,
  setPageSize,
  signalIndexName,
  tableId,
  to
}) => {
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const {
    browserFields: oldBrowserFields,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_model.SourcererScopeName.detections);
  const sourcererDataView = oldSourcererDataView;
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const getGlobalQuery = (0, _react.useCallback)(customFilters => {
    if (browserFields != null && sourcererDataView) {
      return (0, _kuery.combineQueries)({
        config: (0, _common.getEsQueryConfig)(uiSettings),
        dataProviders: [],
        dataViewSpec: sourcererDataView,
        dataView: experimentalDataView,
        browserFields,
        filters: [...defaultFilters, ...globalFilters, ...customFilters, ...(parentGroupingFilter ? JSON.parse(parentGroupingFilter) : []), ...(0, _helpers.buildTimeRangeFilter)(from, to)],
        kqlQuery: globalQuery,
        kqlMode: globalQuery.language
      });
    }
    return null;
  }, [browserFields, sourcererDataView, uiSettings, experimentalDataView, defaultFilters, globalFilters, parentGroupingFilter, from, to, globalQuery]);
  const additionalFilters = (0, _react.useMemo)(() => {
    try {
      var _globalFilters$filter;
      return [(0, _esQuery.buildEsQuery)(undefined, globalQuery != null ? [globalQuery] : [], [...((_globalFilters$filter = globalFilters === null || globalFilters === void 0 ? void 0 : globalFilters.filter(f => f.meta.disabled === false)) !== null && _globalFilters$filter !== void 0 ? _globalFilters$filter : []), ...(defaultFilters !== null && defaultFilters !== void 0 ? defaultFilters : []), ...(parentGroupingFilter ? JSON.parse(parentGroupingFilter) : [])])];
    } catch (e) {
      return [];
    }
  }, [defaultFilters, globalFilters, globalQuery, parentGroupingFilter]);

  // create a unique, but stable (across re-renders) value
  const uniqueValue = (0, _react.useMemo)(() => `SuperUniqueValue-${(0, _uuid.v4)()}`, []);
  const queryGroups = (0, _react.useMemo)(() => {
    return (0, _grouping_settings.getAlertsGroupingQuery)({
      groupStatsAggregations,
      additionalFilters,
      selectedGroup,
      uniqueValue,
      from,
      runtimeMappings,
      to,
      pageSize,
      pageIndex
    });
  }, [additionalFilters, from, groupStatsAggregations, pageIndex, pageSize, runtimeMappings, selectedGroup, to, uniqueValue]);
  const emptyGlobalQuery = (0, _react.useMemo)(() => getGlobalQuery([]), [getGlobalQuery]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: tableId,
    filterQuery: emptyGlobalQuery === null || emptyGlobalQuery === void 0 ? void 0 : emptyGlobalQuery.filterQuery,
    kqlError: emptyGlobalQuery === null || emptyGlobalQuery === void 0 ? void 0 : emptyGlobalQuery.kqlError,
    query: globalQuery,
    startDate: from,
    endDate: to
  });
  const {
    data: alertsGroupsData,
    loading: isLoadingGroups,
    refetch,
    request,
    response,
    setQuery: setAlertsQuery
  } = (0, _use_query.useQueryAlerts)({
    query: queryGroups,
    indexName: signalIndexName,
    queryName: _constants.ALERTS_QUERY_NAMES.ALERTS_GROUPING,
    skip: (0, _grouping.isNoneGroup)([selectedGroup])
  });
  const queriedGroup = (0, _react.useRef)(null);
  const aggs = (0, _react.useMemo)(
  // queriedGroup because `selectedGroup` updates before the query response
  () => (0, _src.parseGroupingQuery)(
  // fallback to selectedGroup if queriedGroup.current is null, this happens in tests
  queriedGroup.current === null ? selectedGroup : queriedGroup.current, uniqueValue, alertsGroupsData === null || alertsGroupsData === void 0 ? void 0 : alertsGroupsData.aggregations), [alertsGroupsData === null || alertsGroupsData === void 0 ? void 0 : alertsGroupsData.aggregations, selectedGroup, uniqueValue]);
  (0, _react.useEffect)(() => {
    if (!(0, _grouping.isNoneGroup)([selectedGroup])) {
      var _queryGroups$runtime_, _queryGroups$runtime_2, _queryGroups$runtime_3, _queryGroups$runtime_4, _queryGroups$runtime_5;
      queriedGroup.current = (_queryGroups$runtime_ = queryGroups === null || queryGroups === void 0 ? void 0 : (_queryGroups$runtime_2 = queryGroups.runtime_mappings) === null || _queryGroups$runtime_2 === void 0 ? void 0 : (_queryGroups$runtime_3 = _queryGroups$runtime_2.groupByField) === null || _queryGroups$runtime_3 === void 0 ? void 0 : (_queryGroups$runtime_4 = _queryGroups$runtime_3.script) === null || _queryGroups$runtime_4 === void 0 ? void 0 : (_queryGroups$runtime_5 = _queryGroups$runtime_4.params) === null || _queryGroups$runtime_5 === void 0 ? void 0 : _queryGroups$runtime_5.selectedGroup) !== null && _queryGroups$runtime_ !== void 0 ? _queryGroups$runtime_ : '';
      setAlertsQuery(queryGroups);
    }
  }, [queryGroups, selectedGroup, setAlertsQuery]);
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `${ALERTS_GROUPING_ID}-${(0, _uuid.v4)()}`, []);
  (0, _hooks.useInspectButton)({
    deleteQuery,
    loading: isLoadingGroups,
    refetch,
    request,
    response,
    setQuery,
    uniqueQueryId
  });
  const inspect = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: uniqueQueryId,
    inspectIndex: 0,
    title: i18n.INSPECT_GROUPING_TITLE
  }), [uniqueQueryId]);
  const getTakeActionItems = (0, _react.useCallback)((groupFilters, groupNumber) => {
    var _getGlobalQuery, _groupTakeActionItems;
    const takeActionParams = {
      groupNumber,
      query: (_getGlobalQuery = getGlobalQuery([...(defaultFilters !== null && defaultFilters !== void 0 ? defaultFilters : []), ...groupFilters])) === null || _getGlobalQuery === void 0 ? void 0 : _getGlobalQuery.filterQuery,
      selectedGroup,
      tableId
    };
    return (_groupTakeActionItems = groupTakeActionItems === null || groupTakeActionItems === void 0 ? void 0 : groupTakeActionItems(takeActionParams)) !== null && _groupTakeActionItems !== void 0 ? _groupTakeActionItems : [];
  }, [defaultFilters, getGlobalQuery, groupTakeActionItems, selectedGroup, tableId]);
  const onChangeGroupsItemsPerPage = (0, _react.useCallback)(size => setPageSize(size), [setPageSize]);
  const onChangeGroupsPage = (0, _react.useCallback)(index => setPageIndex(index), [setPageIndex]);
  return (0, _react.useMemo)(() => getGrouping({
    activePage: pageIndex,
    data: aggs,
    groupingLevel,
    inspectButton: inspect,
    isLoading: loading || isLoadingGroups,
    itemsPerPage: pageSize,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    onGroupClose,
    renderChildComponent,
    selectedGroup,
    ...(groupTakeActionItems && {
      takeActionItems: getTakeActionItems
    })
  }), [aggs, getGrouping, getTakeActionItems, groupingLevel, groupTakeActionItems, inspect, isLoadingGroups, loading, onChangeGroupsItemsPerPage, onChangeGroupsPage, onGroupClose, pageIndex, pageSize, renderChildComponent, selectedGroup]);
};
exports.GroupedSubLevelComponent = GroupedSubLevelComponent;
const GroupedSubLevel = exports.GroupedSubLevel = /*#__PURE__*/_react.default.memo(GroupedSubLevelComponent);