"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePagination = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE_OPTIONS = [10, 20, 50];
const DEFAULT_PAGE_NUMBER = 1;
const usePagination = args => {
  var _args$pageSizeOptions, _args$pageSizeDefault, _args$pageNumberDefau;
  const pageSizeOptions = (_args$pageSizeOptions = args.pageSizeOptions) !== null && _args$pageSizeOptions !== void 0 ? _args$pageSizeOptions : DEFAULT_PAGE_SIZE_OPTIONS;
  const pageSizeDefault = (_args$pageSizeDefault = args.pageSizeDefault) !== null && _args$pageSizeDefault !== void 0 ? _args$pageSizeDefault : pageSizeOptions[0];
  const pageNumberDefault = (_args$pageNumberDefau = args.pageNumberDefault) !== null && _args$pageNumberDefau !== void 0 ? _args$pageNumberDefau : DEFAULT_PAGE_NUMBER;
  const [pageSize, setPageSize] = (0, _react.useState)(pageSizeDefault);
  const [pageNumber, setPageNumber] = (0, _react.useState)(pageNumberDefault);
  const [totalItemCount, setTotalItemCount] = (0, _react.useState)(0);
  const state = (0, _react.useMemo)(() => {
    return {
      pageSizeOptions,
      pageSize,
      pageNumber,
      pageIndex: pageNumber - 1,
      totalItemCount
    };
  }, [pageSizeOptions, pageSize, pageNumber, totalItemCount]);
  const update = (0, _react.useCallback)(criteria => {
    setPageNumber(criteria.page.index + 1);
    setPageSize(criteria.page.size);
  }, [setPageNumber, setPageSize]);
  const updateTotalItemCount = (0, _react.useCallback)(count => {
    setTotalItemCount(count !== null && count !== void 0 ? count : 0);
  }, [setTotalItemCount]);
  return (0, _react.useMemo)(() => ({
    state,
    update,
    updateTotalItemCount
  }), [state, update, updateTotalItemCount]);
};
exports.usePagination = usePagination;