"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpandableRows = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExpandableRows = args => {
  const {
    getItemId,
    renderItem
  } = args;
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const toggleRowExpanded = (0, _react.useCallback)(item => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    const itemId = getItemId(item);
    if (itemIdToExpandedRowMapValues[itemId]) {
      delete itemIdToExpandedRowMapValues[itemId];
    } else {
      itemIdToExpandedRowMapValues[itemId] = renderItem(item);
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  }, [itemIdToExpandedRowMap, getItemId, renderItem]);
  const isRowExpanded = (0, _react.useCallback)(item => {
    const itemId = getItemId(item);
    return itemIdToExpandedRowMap[itemId] != null;
  }, [itemIdToExpandedRowMap, getItemId]);
  return (0, _react.useMemo)(() => {
    return {
      itemIdToExpandedRowMap,
      getItemId,
      toggleRowExpanded,
      isRowExpanded
    };
  }, [itemIdToExpandedRowMap, getItemId, toggleRowExpanded, isRowExpanded]);
};
exports.useExpandableRows = useExpandableRows;