"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionRuleErrorsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _translations = require("../../../../common/translations");
var _use_prebuilt_rule_customization_upselling_message = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rule_customization_upselling_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkEditRuleErrorItem = ({
  errorCode,
  message,
  rulesCount
}) => {
  const upsellingMessage = (0, _use_prebuilt_rule_customization_upselling_message.usePrebuiltRuleCustomizationUpsellingMessage)('prebuilt_rule_customization');
  switch (errorCode) {
    case _rule_management.BulkActionsDryRunErrCodeEnum.IMMUTABLE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.elasticRulesEditDescription",
        defaultMessage: "{rulesCount, plural, =1 {# prebuilt Elastic rule} other {# prebuilt Elastic rules}} (editing prebuilt rules is not supported)",
        values: {
          rulesCount
        }
      }));
    case _rule_management.BulkActionsDryRunErrCodeEnum.PREBUILT_CUSTOMIZATION_LICENSE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.prebuiltRulesLicenseDescription",
        defaultMessage: "{rulesCount, plural, =1 {# prebuilt rule} other {# prebuilt rules}} ({upsellingMessage})",
        values: {
          rulesCount,
          upsellingMessage
        }
      }));
    case _rule_management.BulkActionsDryRunErrCodeEnum.MACHINE_LEARNING_INDEX_PATTERN:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.machineLearningRulesIndexEditDescription",
        defaultMessage: "{rulesCount, plural, =1 {# machine learning rule} other {# machine learning rules}} (these rules don't have index patterns)",
        values: {
          rulesCount
        }
      }));
    case _rule_management.BulkActionsDryRunErrCodeEnum.MACHINE_LEARNING_AUTH:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.machineLearningRulesAuthDescription",
        defaultMessage: "{rulesCount, plural, =1 {# machine learning rule} other {# machine learning rules}} can't be edited ({message})",
        values: {
          rulesCount,
          message
        }
      }));
    case _rule_management.BulkActionsDryRunErrCodeEnum.ESQL_INDEX_PATTERN:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.esqlRulesIndexEditDescription",
        defaultMessage: "{rulesCount, plural, =1 {# ES|QL rule} other {# ES|QL rules}} (these rules don't have index patterns)",
        values: {
          rulesCount
        }
      }));
    case _rule_management.BulkActionsDryRunErrCodeEnum.THRESHOLD_RULE_TYPE_IN_SUPPRESSION:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.thresholdRuleInSuppressionDescription",
        defaultMessage: "{rulesCount, plural, =1 {# threshold rule} other {# threshold rules}} can't be edited. To bulk-apply alert suppression {rulesCount, plural, =1 {to this rule} other {to these rules}}, use the {actionStrong} option.",
        values: {
          rulesCount,
          actionStrong: /*#__PURE__*/_react.default.createElement("strong", null, _translations.BULK_ACTION_SET_ALERT_SUPPRESSION_FOR_THRESHOLD)
        }
      }));
    case _rule_management.BulkActionsDryRunErrCodeEnum.UNSUPPORTED_RULE_IN_SUPPRESSION_FOR_THRESHOLD:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.unsupportedRulesInThresholdSuppressionDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} can't be edited. To bulk-apply alert suppression {rulesCount, plural, =1 {to this rule} other {to these rules}}, use the {actionStrong} option.",
        values: {
          rulesCount,
          actionStrong: /*#__PURE__*/_react.default.createElement("strong", null, _translations.BULK_ACTION_SET_ALERT_SUPPRESSION)
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.defaultRulesEditFailureDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} can't be edited ({message})",
        values: {
          rulesCount,
          message
        }
      }));
  }
};
const BulkExportRuleErrorItem = ({
  errorCode,
  message,
  rulesCount
}) => {
  switch (errorCode) {
    case _rule_management.BulkActionsDryRunErrCodeEnum.IMMUTABLE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.elasticRulesExportDescription",
        defaultMessage: "{rulesCount, plural, =1 {# prebuilt Elastic rule} other {# prebuilt Elastic rules}} (exporting prebuilt rules is not supported)",
        values: {
          rulesCount
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.defaultRulesExportFailureDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} can't be exported ({message})",
        values: {
          rulesCount,
          message
        }
      }));
  }
};
const BulkManualRuleRunErrorItem = ({
  errorCode,
  message,
  rulesCount
}) => {
  switch (errorCode) {
    case _rule_management.BulkActionsDryRunErrCodeEnum.MANUAL_RULE_RUN_FEATURE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.manualRuleRunFeatureDisabledDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} (Manual rule run feature is disabled)",
        values: {
          rulesCount
        }
      }));
    case _rule_management.BulkActionsDryRunErrCodeEnum.MANUAL_RULE_RUN_DISABLED_RULE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.scheduleDisabledRuleDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} (Cannot schedule manual rule run for disabled rules)",
        values: {
          rulesCount
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.defaultScheduleRuleRunFailureDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} can't be scheduled ({message})",
        values: {
          rulesCount,
          message
        }
      }));
  }
};
const BulkFillRuleGapsErrorItem = ({
  errorCode,
  message,
  rulesCount
}) => {
  switch (errorCode) {
    case _rule_management.BulkActionsDryRunErrCodeEnum.RULE_FILL_GAPS_DISABLED_RULE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.fillGapsDisabledRuleDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} (Cannot fill gaps for disabled rules)",
        values: {
          rulesCount
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.defaultScheduleRuleRunFailureDescription",
        defaultMessage: "Cannot fill gaps for {rulesCount, plural, =1 {# rule} other {# rules}} ({message})",
        values: {
          rulesCount,
          message
        }
      }));
  }
};
const BulkActionRuleErrorsListComponent = ({
  ruleErrors = [],
  bulkAction
}) => {
  if (ruleErrors.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.actionRejectionDescription",
    defaultMessage: "This action can't be applied to the following rules in your selection:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("ul", null, ruleErrors.map(({
    message,
    errorCode,
    ruleIds
  }) => {
    const rulesCount = ruleIds.length;
    switch (bulkAction) {
      case _rule_management.BulkActionTypeEnum.edit:
        return /*#__PURE__*/_react.default.createElement(BulkEditRuleErrorItem, {
          message: message,
          errorCode: errorCode,
          rulesCount: rulesCount
        });
      case _rule_management.BulkActionTypeEnum.export:
        return /*#__PURE__*/_react.default.createElement(BulkExportRuleErrorItem, {
          message: message,
          errorCode: errorCode,
          rulesCount: rulesCount
        });
      case _rule_management.BulkActionTypeEnum.run:
        return /*#__PURE__*/_react.default.createElement(BulkManualRuleRunErrorItem, {
          message: message,
          errorCode: errorCode,
          rulesCount: rulesCount
        });
      case _rule_management.BulkActionTypeEnum.fill_gaps:
        return /*#__PURE__*/_react.default.createElement(BulkFillRuleGapsErrorItem, {
          message: message,
          errorCode: errorCode,
          rulesCount: rulesCount
        });
      default:
        return null;
    }
  })));
};
const BulkActionRuleErrorsList = exports.BulkActionRuleErrorsList = /*#__PURE__*/_react.default.memo(BulkActionRuleErrorsListComponent);
BulkActionRuleErrorsList.displayName = 'BulkActionRuleErrorsList';