"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrequencyDescription = void 0;
exports.NotificationAction = NotificationAction;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _helpers = require("../../../rule_creation_ui/pages/rule_creation/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DescriptionLine = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued"
}, children));
const FrequencyDescription = ({
  frequency
}) => {
  if (!frequency) {
    return null;
  }
  if (!frequency.summary) {
    return /*#__PURE__*/_react.default.createElement(DescriptionLine, null, i18n.FOR_EACH_ALERT_PER_RULE_RUN);
  }
  if (frequency.notifyWhen === 'onActiveAlert') {
    return /*#__PURE__*/_react.default.createElement(DescriptionLine, null, i18n.SUMMARY_OF_ALERTS_PER_RULE_RUN);
  }
  if (!frequency.throttle) {
    return null;
  }
  const {
    unit,
    value
  } = (0, _helpers.getTimeTypeValue)(frequency.throttle);
  const messagesByUnit = {
    s: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.ruleDetails.onceInEverySecondsLabel",
      defaultMessage: "Once {secondsCount, plural, one {a} other {in every}} {secondsCount, plural, one {second} other {# seconds}}",
      values: {
        secondsCount: value
      }
    }),
    m: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.ruleDetails.onceInEveryMinutesLabel",
      defaultMessage: "Once {minutesCount, plural, one {a} other {in every}} {minutesCount, plural, one {minute} other {# minutes}}",
      values: {
        minutesCount: value
      }
    }),
    h: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.ruleDetails.onceInEveryHoursLabel",
      defaultMessage: "Once {hoursCount, plural, one {an} other {in every}} {hoursCount, plural, one {hour} other {# hours}}",
      values: {
        hoursCount: value
      }
    }),
    d: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.ruleDetails.onceInEveryDaysLabel",
      defaultMessage: "Once {daysCount, plural, one {a} other {in every}} {daysCount, plural, one {day} other {# days}}",
      values: {
        daysCount: value
      }
    })
  };
  return /*#__PURE__*/_react.default.createElement(DescriptionLine, null, messagesByUnit[unit] || i18n.PERIODICALLY);
};
exports.FrequencyDescription = FrequencyDescription;
function NotificationAction({
  action,
  connectorTypes,
  connectors,
  actionTypeRegistry
}) {
  var _connectorType$name, _registeredAction$act, _registeredAction$ico, _ref;
  const isRuleAction = (0, _helpers.isRuleAction)(action, actionTypeRegistry);
  const connectorType = connectorTypes.find(({
    id
  }) => id === action.actionTypeId);
  const registeredAction = actionTypeRegistry.get(action.actionTypeId);

  /*
  since there is no "connector" for system actions,
  we need to determine the title based off the action
  properties in order to render helpful text on the
  rule details page.
  */
  const connectorTypeName = isRuleAction ? (_connectorType$name = connectorType === null || connectorType === void 0 ? void 0 : connectorType.name) !== null && _connectorType$name !== void 0 ? _connectorType$name : '' : (_registeredAction$act = registeredAction.actionTypeTitle) !== null && _registeredAction$act !== void 0 ? _registeredAction$act : '';
  const iconType = (_registeredAction$ico = registeredAction === null || registeredAction === void 0 ? void 0 : registeredAction.iconClass) !== null && _registeredAction$ico !== void 0 ? _registeredAction$ico : 'apps';
  const connector = connectors.find(({
    id
  }) => id === action.id);
  const connectorName = (_ref = isRuleAction ? connector === null || connector === void 0 ? void 0 : connector.name : registeredAction.actionTypeTitle) !== null && _ref !== void 0 ? _ref : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    component: "span",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: connectorTypeName,
    anchorClassName: "eui-textTruncate",
    type: iconType,
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, connectorName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    component: "span",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "bell",
    color: "subdued"
  })), isRuleAction ? /*#__PURE__*/_react.default.createElement(FrequencyDescription, {
    frequency: action.frequency
  }) :
  /*#__PURE__*/
  // Display frequency description for system action
  // same text used by stack alerting
  _react.default.createElement(DescriptionLine, null, i18n.SYSTEM_ACTION_FREQUENCY)))));
}