"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMELINE_ACTIONS = exports.SINGLE_RULE_ACTIONS = exports.RULES_TABLE_ACTIONS = exports.FIELD_BROWSER_ACTIONS = exports.BULK_RULE_ACTIONS = exports.ALERTS_ACTIONS = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SINGLE_RULE_ACTIONS = exports.SINGLE_RULE_ACTIONS = {
  ENABLE: `${_constants.APP_UI_ID} singleRuleActions enable`,
  DISABLE: `${_constants.APP_UI_ID} singleRuleActions disable`,
  DUPLICATE: `${_constants.APP_UI_ID} singleRuleActions duplicate`,
  EXPORT: `${_constants.APP_UI_ID} singleRuleActions export`,
  DELETE: `${_constants.APP_UI_ID} singleRuleActions delete`,
  MANUAL_RULE_RUN: `${_constants.APP_UI_ID} singleRuleActions manual rule run`,
  PREVIEW: `${_constants.APP_UI_ID} singleRuleActions preview`,
  SAVE: `${_constants.APP_UI_ID} singleRuleActions save`
};
const BULK_RULE_ACTIONS = exports.BULK_RULE_ACTIONS = {
  ENABLE: `${_constants.APP_UI_ID} bulkRuleActions enable`,
  DISABLE: `${_constants.APP_UI_ID} bulkRuleActions disable`,
  DUPLICATE: `${_constants.APP_UI_ID} bulkRuleActions duplicate`,
  EXPORT: `${_constants.APP_UI_ID} bulkRuleActions export`,
  MANUAL_RULE_RUN: `${_constants.APP_UI_ID} bulkRuleActions manual rule run`,
  FILL_GAPS: `${_constants.APP_UI_ID} bulkRuleActions fill gaps`,
  DELETE: `${_constants.APP_UI_ID} bulkRuleActions delete`,
  EDIT: `${_constants.APP_UI_ID} bulkRuleActions edit`
};
const RULES_TABLE_ACTIONS = exports.RULES_TABLE_ACTIONS = {
  REFRESH: `${_constants.APP_UI_ID} rulesTable refresh`,
  FILTER: `${_constants.APP_UI_ID} rulesTable filter`,
  LOAD_PREBUILT: `${_constants.APP_UI_ID} rulesTable loadPrebuilt`
};
const TIMELINE_ACTIONS = exports.TIMELINE_ACTIONS = {
  SAVE: `${_constants.APP_UI_ID} timeline save`,
  DUPLICATE: `${_constants.APP_UI_ID} timeline duplicate`,
  // it includes duplicate template, create template from timeline and create timeline from template
  DELETE: `${_constants.APP_UI_ID} timeline delete`,
  BULK_DELETE: `${_constants.APP_UI_ID} timeline bulkDelete`
};
const ALERTS_ACTIONS = exports.ALERTS_ACTIONS = {
  OPEN_ANALYZER: `${_constants.APP_UI_ID} alerts openAnalyzer`,
  OPEN_SESSION_VIEW: `${_constants.APP_UI_ID} alerts openSessionView`,
  INVESTIGATE_IN_TIMELINE: `${_constants.APP_UI_ID} alerts investigateInTimeline`
};
const FIELD_BROWSER_ACTIONS = exports.FIELD_BROWSER_ACTIONS = {
  FIELD_SAVED: `${_constants.APP_UI_ID} fieldBrowser fieldSaved`,
  FIELD_DELETED: `${_constants.APP_UI_ID} fieldBrowser fieldDeleted`
};