"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEventDetailsWidthContext = exports.EventDetailsWidthProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_WIDTH = 0;
const EventDetailsWidthContext = /*#__PURE__*/(0, _react.createContext)(DEFAULT_WIDTH);
const useEventDetailsWidthContext = () => (0, _react.useContext)(EventDetailsWidthContext);
exports.useEventDetailsWidthContext = useEventDetailsWidthContext;
const EventDetailsWidthProvider = exports.EventDetailsWidthProvider = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const {
    ref,
    width
  } = (0, _utils.useThrottledResizeObserver)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EventDetailsWidthContext.Provider, {
    value: width !== null && width !== void 0 ? width : DEFAULT_WIDTH
  }, children), /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }));
});
EventDetailsWidthProvider.displayName = 'EventDetailsWidthProvider';