"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssigneesApplyPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _test_ids = require("./test_ids");
var _assignees_selectable = require("./assignees_selectable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The popover to allow selection of users from a list
 */
const AssigneesApplyPanel = exports.AssigneesApplyPanel = /*#__PURE__*/(0, _react.memo)(({
  searchInputId,
  assignedUserIds,
  onApply
}) => {
  /**
   * We use `selectedUserIds` to keep track of currently selected user ids,
   * whereas `assignedUserIds` holds actually assigned user ids.
   */
  const [selectedUserIds, setSelectedUserIds] = (0, _react.useState)(assignedUserIds);
  const assigneesToUpdate = (0, _react.useMemo)(() => {
    const updatedIds = (0, _utils.removeNoAssigneesSelection)(selectedUserIds);
    const assigneesToAddArray = updatedIds.filter(uid => !assignedUserIds.includes(uid));
    const assigneesToRemoveArray = assignedUserIds.filter(uid => !updatedIds.includes(uid));
    return {
      add: assigneesToAddArray,
      remove: assigneesToRemoveArray
    };
  }, [assignedUserIds, selectedUserIds]);
  const isDirty = (0, _react.useMemo)(() => assigneesToUpdate.add.length || assigneesToUpdate.remove.length, [assigneesToUpdate]);
  const handleSelectionChange = (0, _react.useCallback)(userIds => {
    setSelectedUserIds(userIds);
  }, []);
  const handleApplyButtonClick = (0, _react.useCallback)(async () => {
    onApply(assigneesToUpdate);
  }, [assigneesToUpdate, onApply]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ASSIGNEES_APPLY_PANEL_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_assignees_selectable.AssigneesSelectable, {
    searchInputId: searchInputId,
    assignedUserIds: assignedUserIds,
    onSelectionChange: handleSelectionChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": _test_ids.ASSIGNEES_APPLY_BUTTON_TEST_ID,
    fullWidth: true,
    size: "s",
    onClick: handleApplyButtonClick,
    isDisabled: !isDirty
  }, i18n.ASSIGNEES_APPLY_BUTTON));
});
AssigneesApplyPanel.displayName = 'AssigneesPanel';