"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryCount = exports.EMPTY_LAST_UPDATED_DATE = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _separator = require("../separator");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_LAST_UPDATED_DATE = exports.EMPTY_LAST_UPDATED_DATE = '--';

/** We don't know the exact count above this threshold */
const EXACT_COUNT_THRESHOLD = 1000;
const SummaryCountComponent = ({
  alertsCount,
  attackDiscoveriesCount,
  lastUpdated
}) => {
  const [formattedDate, setFormattedDate] = (0, _react2.useState)(EMPTY_LAST_UPDATED_DATE);
  (0, _react2.useEffect)(() => {
    // immediately update the formatted date when lastUpdated is updated:
    if ((0, _moment.default)(lastUpdated).isValid()) {
      setFormattedDate((0, _moment.default)(lastUpdated).fromNow());
    }

    // periodically update the formatted date as time passes:
    const intervalId = setInterval(() => {
      if ((0, _moment.default)(lastUpdated).isValid()) {
        setFormattedDate((0, _moment.default)(lastUpdated).fromNow());
      }
    }, 10000);
    return () => clearInterval(intervalId);
  }, [lastUpdated]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
        font-weight: 700;
      `,
    "data-test-subj": "summaryCount",
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "discoveriesCount",
    grow: false
  }, (0, _translations.DISCOVERIES)(attackDiscoveriesCount)), /*#__PURE__*/_react2.default.createElement(_separator.Separator, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "alertsCount",
    grow: false
  }, alertsCount >= EXACT_COUNT_THRESHOLD ? (0, _translations.PLUS_ALERTS)(alertsCount) : (0, _translations.ALERTS)(alertsCount)), lastUpdated != null && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_separator.Separator, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "lastGenerated",
    grow: false
  }, _translations.LAST_GENERATED, ': ', formattedDate))));
};
SummaryCountComponent.displayName = 'SummaryCount';
const SummaryCount = exports.SummaryCount = /*#__PURE__*/_react2.default.memo(SummaryCountComponent);