"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlyoutPanelProps = void 0;
var _get_host_flyout_panel_props = require("./get_host_flyout_panel_props");
var _get_user_flyout_panel_props = require("./get_user_flyout_panel_props");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFlyoutPanelProps = ({
  contextId,
  fieldName,
  value
}) => {
  if ((0, _get_host_flyout_panel_props.isHostName)(fieldName) && typeof value === 'string') {
    return (0, _get_host_flyout_panel_props.getHostFlyoutPanelProps)({
      contextId,
      hostName: value
    });
  }
  if ((0, _get_user_flyout_panel_props.isUserName)(fieldName) && typeof value === 'string') {
    return (0, _get_user_flyout_panel_props.getUserFlyoutPanelProps)({
      contextId,
      userName: value
    });
  }
  return null;
};
exports.getFlyoutPanelProps = getFlyoutPanelProps;