"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAgentTypeInTechPreview = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TECH_PREVIEW_AGENT_TYPE = Object.freeze({
  endpoint: false,
  microsoft_defender_endpoint: false,
  crowdstrike: false,
  sentinel_one: false
});

/**
 * Returns boolean indicating if agent type is in tech preview or not.
 * @param agentType
 */
const isAgentTypeInTechPreview = agentType => {
  var _TECH_PREVIEW_AGENT_T;
  return (_TECH_PREVIEW_AGENT_T = TECH_PREVIEW_AGENT_TYPE[agentType]) !== null && _TECH_PREVIEW_AGENT_T !== void 0 ? _TECH_PREVIEW_AGENT_T : true;
};
exports.isAgentTypeInTechPreview = isAgentTypeInTechPreview;