"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserName = exports.MonitoredUserDoc = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Privilege Monitoring Users Common Schema
 *   version: 1
 */

const UserName = exports.UserName = _zod.z.object({
  user: _zod.z.object({
    /**
     * The name of the user.
     */
    name: _zod.z.string().optional()
  }).optional()
});
const MonitoredUserDoc = exports.MonitoredUserDoc = _zod.z.object({
  id: _zod.z.string().optional(),
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional()
  }).optional(),
  '@timestamp': _zod.z.string().datetime().optional(),
  user: _zod.z.object({
    name: _zod.z.string().optional(),
    /**
     * Indicates if the user is privileged.
     */
    is_privileged: _zod.z.boolean().optional()
  }).optional(),
  labels: _zod.z.object({
    sources: _zod.z.array(_zod.z.unknown()).optional(),
    source_indices: _zod.z.array(_zod.z.string()).optional(),
    source_integrations: _zod.z.array(_zod.z.string()).optional()
  }).optional(),
  entity_analytics_monitoring: _zod.z.object({
    labels: _zod.z.array(_zod.z.object({
      field: _zod.z.string().optional(),
      value: _zod.z.string().optional(),
      source: _zod.z.string().optional()
    })).optional()
  }).optional()
});