"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEnabledProductFeaturesConfigMap = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates the ProductFeaturesConfig Map from the given productFeatures object and a set of enabled productFeatures keys.
 */
const createEnabledProductFeaturesConfigMap = (productFeatures, enabledProductFeaturesKeys) => new Map(Object.entries(productFeatures).reduce((acc, [key, value]) => {
  if (enabledProductFeaturesKeys.includes(key)) {
    acc.push([key, value]);
  }
  return acc;
}, []));
exports.createEnabledProductFeaturesConfigMap = createEnabledProductFeaturesConfigMap;