"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigationTree = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _navigation_tree = require("@kbn/security-solution-navigation/navigation_tree");
var _links = require("@kbn/security-solution-navigation/links");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNavigationTree = services => ({
  body: [{
    type: 'navGroup',
    id: 'security_solution_nav',
    title: _translations.SOLUTION_NAME,
    icon: 'logoSecurity',
    breadcrumbStatus: 'hidden',
    defaultIsCollapsed: false,
    isCollapsible: false,
    children: [{
      link: 'discover'
    }, _navigation_tree.defaultNavigationTree.dashboards(), {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.rules(), {
        id: _securitySolutionNavigation.SecurityPageName.alerts,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.alerts)
      }, {
        id: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.attackDiscovery)
      }, {
        id: _securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings)
      }, _navigation_tree.defaultNavigationTree.cases()]
    }, {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.entityAnalytics(), _navigation_tree.defaultNavigationTree.explore(), _navigation_tree.defaultNavigationTree.investigations(), {
        id: _securitySolutionNavigation.SecurityPageName.threatIntelligence,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.threatIntelligence)
      }]
    }, {
      breadcrumbStatus: 'hidden',
      children: [{
        id: _securitySolutionNavigation.SecurityPageName.assetInventory,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.assetInventory)
      }, _navigation_tree.defaultNavigationTree.assets(services)]
    }, _navigation_tree.defaultNavigationTree.ml()]
  }],
  footer: [{
    id: 'security_solution_nav_footer',
    type: 'navGroup',
    children: [{
      id: _securitySolutionNavigation.SecurityPageName.landing,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
      icon: 'launch'
    }, {
      link: 'dev_tools',
      title: _links.i18nStrings.devTools,
      icon: 'editorCodeBlock'
    }, {
      title: _links.i18nStrings.management.title,
      icon: 'gear',
      breadcrumbStatus: 'hidden',
      renderAs: 'accordion',
      spaceBefore: null,
      children: [{
        id: 'stack_management',
        title: _links.i18nStrings.stackManagement.title,
        renderAs: 'panelOpener',
        spaceBefore: null,
        children: [{
          title: _links.i18nStrings.stackManagement.ingest.title,
          children: [{
            link: 'management:ingest_pipelines'
          }, {
            link: 'management:pipelines'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.data.title,
          children: [{
            link: 'management:index_management'
          }, {
            link: 'management:index_lifecycle_management'
          }, {
            link: 'management:snapshot_restore'
          }, {
            link: 'management:rollup_jobs'
          }, {
            link: 'management:transform'
          }, {
            link: 'management:cross_cluster_replication'
          }, {
            link: 'management:remote_clusters'
          }, {
            link: 'management:migrate_data'
          }, {
            link: 'management:content_connectors'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.alertsAndInsights.title,
          children: [{
            link: 'management:triggersActions'
          }, {
            link: 'management:cases'
          }, {
            link: 'management:triggersActionsConnectors'
          }, {
            link: 'management:reporting'
          }, {
            link: 'management:jobsListLink'
          }, {
            link: 'management:watcher'
          }, {
            link: 'management:maintenanceWindows'
          }, {
            id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement)
          }, {
            id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement)
          }]
        }, {
          title: _links.i18nStrings.ml.title,
          children: [{
            link: 'management:overview'
          }, {
            link: 'management:anomaly_detection'
          }, {
            link: 'management:analytics'
          }, {
            link: 'management:trained_models'
          }, {
            link: 'management:supplied_configurations'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.security.title,
          children: [{
            link: 'management:users'
          }, {
            link: 'management:roles'
          }, {
            link: 'management:api_keys'
          }, {
            link: 'management:role_mappings'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.kibana.title,
          children: [{
            link: 'management:dataViews'
          }, {
            link: 'management:filesManagement'
          }, {
            link: 'management:objects'
          }, {
            link: 'management:tags'
          }, {
            link: 'management:search_sessions'
          }, {
            link: 'management:aiAssistantManagementSelection'
          }, {
            link: 'management:spaces'
          }, {
            link: 'maps'
          }, {
            link: 'visualize'
          }, {
            link: 'graph'
          }, {
            link: 'canvas'
          }, {
            link: 'management:settings'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.stack.title,
          children: [{
            link: 'management:license_management'
          }, {
            link: 'management:upgrade_assistant'
          }]
        }]
      }, {
        link: 'monitoring'
      }, {
        link: 'integrations'
      }]
    }]
  }]
});
exports.createNavigationTree = createNavigationTree;