"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageMode = exports.MessageType = exports.LoginForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./login_form.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _validate_login = require("./validate_login");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var LoadingStateType = /*#__PURE__*/function (LoadingStateType) {
  LoadingStateType[LoadingStateType["None"] = 0] = "None";
  LoadingStateType[LoadingStateType["Form"] = 1] = "Form";
  LoadingStateType[LoadingStateType["Selector"] = 2] = "Selector";
  LoadingStateType[LoadingStateType["AutoLogin"] = 3] = "AutoLogin";
  return LoadingStateType;
}(LoadingStateType || {});
let MessageType = exports.MessageType = /*#__PURE__*/function (MessageType) {
  MessageType[MessageType["None"] = 0] = "None";
  MessageType[MessageType["Info"] = 1] = "Info";
  MessageType[MessageType["Danger"] = 2] = "Danger";
  return MessageType;
}({});
let PageMode = exports.PageMode = /*#__PURE__*/function (PageMode) {
  PageMode[PageMode["Selector"] = 0] = "Selector";
  PageMode[PageMode["Form"] = 1] = "Form";
  PageMode[PageMode["LoginHelp"] = 2] = "LoginHelp";
  return PageMode;
}({});
class LoginForm extends _react.Component {
  constructor(props) {
    var _this$suggestedProvid;
    super(props);
    (0, _defineProperty2.default)(this, "validator", void 0);
    /**
     * Optional provider that was suggested by the `auth_provider_hint={providerName}` query string parameter. If provider
     * doesn't require Kibana native login form then login process is triggered automatically, otherwise Login Selector
     * just switches to the Login Form mode.
     */
    (0, _defineProperty2.default)(this, "suggestedProvider", void 0);
    (0, _defineProperty2.default)(this, "renderLoginAssistanceMessage", () => {
      if (!this.props.loginAssistanceMessage) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "loginAssistanceMessage",
        className: "secLoginAssistanceMessage"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        size: "half"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, null, this.props.loginAssistanceMessage)));
    });
    (0, _defineProperty2.default)(this, "renderMessage", () => {
      const {
        message
      } = this.state;
      if (message.type === MessageType.Danger) {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          size: "s",
          color: "danger",
          "data-test-subj": "loginErrorMessage",
          title: message.content,
          role: "alert"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "l"
        }));
      }
      if (message.type === MessageType.Info) {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          size: "s",
          color: "primary",
          "data-test-subj": "loginInfoMessage",
          title: message.content,
          role: "status"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "l"
        }));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "renderLoginForm", () => {
      const loginSelectorLink = this.showLoginSelector() ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "loginBackToSelector",
        size: "xs",
        onClick: () => this.onPageModeChange(PageMode.Selector)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.loginPage.loginSelectorLinkText",
        defaultMessage: "More login options"
      }))) : null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        "data-test-subj": "loginForm",
        color: "transparent"
      }, /*#__PURE__*/_react.default.createElement("form", {
        onSubmit: this.submitLoginForm
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.login.basicLoginForm.usernameFormRowLabel",
          defaultMessage: "Username"
        })
      }, this.validator.validateUsername(this.state.username)), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        autoComplete: "off",
        id: "username",
        name: "username",
        "data-test-subj": "loginUsername",
        value: this.state.username,
        onChange: this.onUsernameChange,
        disabled: !this.isLoadingState(LoadingStateType.None),
        isInvalid: false,
        "aria-required": true,
        inputRef: this.setUsernameInputRef
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.login.basicLoginForm.passwordFormRowLabel",
          defaultMessage: "Password"
        })
      }, this.validator.validatePassword(this.state.password)), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        autoComplete: "off",
        id: "password",
        name: "password",
        "data-test-subj": "loginPassword",
        type: 'dual',
        value: this.state.password,
        onChange: this.onPasswordChange,
        disabled: !this.isLoadingState(LoadingStateType.None),
        isInvalid: false,
        "aria-required": true
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        alignItems: "center",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        fullWidth: true,
        type: "submit",
        color: "primary",
        onClick: this.submitLoginForm,
        isDisabled: !this.isLoadingState(LoadingStateType.None),
        isLoading: this.isLoadingState(LoadingStateType.Form),
        "data-test-subj": "loginSubmit"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.login.basicLoginForm.logInButtonLabel",
        defaultMessage: "Log in"
      }))), loginSelectorLink)));
    });
    (0, _defineProperty2.default)(this, "renderSelector", () => {
      const providers = this.props.selector.providers.filter(provider => provider.showInSelector);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        "data-test-subj": "loginSelector",
        paddingSize: "none"
      }, providers.map(provider => {
        var _provider$description;
        return /*#__PURE__*/_react.default.createElement("button", {
          key: provider.name,
          "data-test-subj": `loginCard-${provider.type}/${provider.name}`,
          disabled: !this.isLoadingState(LoadingStateType.None),
          onClick: () => provider.usesLoginForm ? this.onPageModeChange(PageMode.Form) : this.loginWithSelector({
            provider
          }),
          className: `secLoginCard ${this.isLoadingState(LoadingStateType.Selector, provider.name) ? 'secLoginCard-isLoading' : ''}`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "m",
          responsive: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "xl",
          type: provider.icon ? provider.icon : 'empty'
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "xs",
          className: "secLoginCard__title"
        }, /*#__PURE__*/_react.default.createElement("p", null, (_provider$description = provider.description) !== null && _provider$description !== void 0 ? _provider$description : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.loginPage.loginProviderDescription",
          defaultMessage: "Log in with {providerType}/{providerName}",
          values: {
            providerType: provider.type,
            providerName: provider.name
          }
        }))), provider.hint ? /*#__PURE__*/_react.default.createElement("p", {
          className: "secLoginCard__hint"
        }, provider.hint) : null), this.isLoadingState(LoadingStateType.Selector, provider.name) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m"
        })) : null));
      }));
    });
    (0, _defineProperty2.default)(this, "renderLoginHelp", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        "data-test-subj": "loginHelp"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, null, this.props.loginHelp || '')));
    });
    (0, _defineProperty2.default)(this, "renderPageModeSwitchLink", () => {
      if (this.state.mode === PageMode.LoginHelp) {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          className: "eui-textCenter"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "loginBackToLoginLink",
          onClick: () => this.onPageModeChange(this.state.previousMode)
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.loginPage.goBackToLoginLink",
          defaultMessage: "Take me back to Login"
        }))));
      }
      if (this.props.loginHelp) {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          className: "eui-textCenter"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "loginHelpLink",
          onClick: () => this.onPageModeChange(PageMode.LoginHelp)
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.loginPage.loginHelpLinkText",
          defaultMessage: "Need help?"
        }))));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "renderAutoLoginOverlay", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": "autoLoginOverlay",
        alignItems: "center",
        justifyContent: "center",
        gutterSize: "m",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m",
        className: "eui-textCenter"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.loginPage.autoLoginAuthenticatingLabel",
        defaultMessage: "Authenticating\u2026"
      }))));
    });
    (0, _defineProperty2.default)(this, "onPageModeChange", mode => {
      this.setState({
        message: {
          type: MessageType.None
        },
        mode,
        previousMode: this.state.mode
      });
    });
    (0, _defineProperty2.default)(this, "onUsernameChange", e => {
      this.setState({
        username: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onPasswordChange", e => {
      this.setState({
        password: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "submitLoginForm", async e => {
      e.preventDefault();
      this.validator.enableValidation();
      const {
        username,
        password
      } = this.state;
      if (this.validator.validateForLogin(username, password).isInvalid) {
        // Since validation is enabled now, we should ask React to re-render form and display
        // validation error messages if any.
        return this.forceUpdate();
      }
      this.setState({
        loadingState: {
          type: LoadingStateType.Form
        },
        message: {
          type: MessageType.None
        }
      });

      // We try to log in with the provider that uses login form and has the lowest order.
      const providerToLoginWith = this.props.selector.providers.find(provider => provider.usesLoginForm);
      try {
        const {
          location
        } = await this.props.http.post('/internal/security/login', {
          body: JSON.stringify({
            providerType: providerToLoginWith.type,
            providerName: providerToLoginWith.name,
            currentURL: window.location.href,
            params: {
              username,
              password
            }
          })
        });
        window.location.href = location;
      } catch (error) {
        var _response;
        const message = ((_response = error.response) === null || _response === void 0 ? void 0 : _response.status) === 401 ? _i18n.i18n.translate('xpack.security.login.basicLoginForm.usernameOrPasswordIsIncorrectErrorMessage', {
          defaultMessage: 'Username or password is incorrect. Please try again.'
        }) : _i18n.i18n.translate('xpack.security.login.basicLoginForm.unknownErrorMessage', {
          defaultMessage: `We couldn't log you in. Please try again.`
        });
        this.setState({
          message: {
            type: MessageType.Danger,
            content: message
          },
          loadingState: {
            type: LoadingStateType.None
          }
        });
      }
    });
    (0, _defineProperty2.default)(this, "loginWithSelector", async ({
      provider: {
        type: providerType,
        name: providerName
      },
      autoLogin
    }) => {
      this.setState({
        loadingState: autoLogin ? {
          type: LoadingStateType.AutoLogin
        } : {
          type: LoadingStateType.Selector,
          providerName
        },
        message: {
          type: MessageType.None
        }
      });
      try {
        const {
          location
        } = await this.props.http.post('/internal/security/login', {
          body: JSON.stringify({
            providerType,
            providerName,
            currentURL: window.location.href
          })
        });
        window.location.href = location;
      } catch (err) {
        var _err$body, _err$body2;
        this.props.notifications.toasts.addError(err !== null && err !== void 0 && (_err$body = err.body) !== null && _err$body !== void 0 && _err$body.message ? new Error(err === null || err === void 0 ? void 0 : (_err$body2 = err.body) === null || _err$body2 === void 0 ? void 0 : _err$body2.message) : err, {
          title: _i18n.i18n.translate('xpack.security.loginPage.loginSelectorErrorMessage', {
            defaultMessage: 'Could not perform login.'
          }),
          toastMessage: err === null || err === void 0 ? void 0 : err.message
        });
        this.setState({
          loadingState: {
            type: LoadingStateType.None
          }
        });
      }
    });
    this.validator = new _validate_login.LoginValidator({
      shouldValidate: false
    });
    this.suggestedProvider = this.props.authProviderHint ? this.props.selector.providers.find(({
      name
    }) => name === this.props.authProviderHint) : undefined;

    // Switch to the Form mode right away if provider from the hint requires it.
    const _mode = this.showLoginSelector() && !((_this$suggestedProvid = this.suggestedProvider) !== null && _this$suggestedProvid !== void 0 && _this$suggestedProvid.usesLoginForm) ? PageMode.Selector : PageMode.Form;
    this.state = {
      loadingState: {
        type: LoadingStateType.None
      },
      username: '',
      password: '',
      message: this.props.message || {
        type: MessageType.None
      },
      mode: _mode,
      previousMode: _mode
    };
  }
  async componentDidMount() {
    var _this$suggestedProvid2;
    if (((_this$suggestedProvid2 = this.suggestedProvider) === null || _this$suggestedProvid2 === void 0 ? void 0 : _this$suggestedProvid2.usesLoginForm) === false) {
      await this.loginWithSelector({
        provider: this.suggestedProvider,
        autoLogin: true
      });
    }
  }
  render() {
    if (this.isLoadingState(LoadingStateType.AutoLogin)) {
      return this.renderAutoLoginOverlay();
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.renderLoginAssistanceMessage(), this.renderMessage(), this.renderContent(), this.renderPageModeSwitchLink());
  }
  renderContent() {
    switch (this.state.mode) {
      case PageMode.Form:
        return this.renderLoginForm();
      case PageMode.Selector:
        return this.renderSelector();
      case PageMode.LoginHelp:
        return this.renderLoginHelp();
    }
  }
  setUsernameInputRef(ref) {
    if (ref) {
      ref.focus();
    }
  }
  isLoadingState(type, providerName) {
    const {
      loadingState
    } = this.state;
    if (loadingState.type !== type) {
      return false;
    }
    return loadingState.type !== LoadingStateType.Selector || loadingState.providerName === providerName;
  }
  showLoginSelector() {
    return this.props.selector.enabled && this.props.selector.providers.some(provider => !provider.usesLoginForm && provider.showInSelector);
  }
}
exports.LoginForm = LoginForm;