"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepLogistics = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _documentation_links = require("../../../services/documentation_links");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexPatternIllegalCharacters = _public2.indexPatterns.ILLEGAL_CHARACTERS_VISIBLE.join(' ');
const indexIllegalCharacters = _shared_imports.indices.INDEX_ILLEGAL_CHARACTERS_VISIBLE.join(' ');
class StepLogistics extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      cronFocus: false
    });
    (0, _defineProperty2.default)(this, "showAdvancedCron", () => {
      this.setState({
        cronFocus: true
      });
      const {
        onFieldsChange
      } = this.props;
      onFieldsChange({
        isAdvancedCronVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "hideAdvancedCron", () => {
      this.setState({
        cronFocus: true
      });
      const {
        onFieldsChange,
        fields
      } = this.props;
      const {
        simpleRollupCron
      } = fields;
      onFieldsChange({
        isAdvancedCronVisible: false,
        // Restore the last value of the simple cron editor.
        rollupCron: simpleRollupCron
      });
    });
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areStepErrorsVisible,
        hasErrors
      } = this.props;
      if (!areStepErrorsVisible || !hasErrors) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_components.StepError, null);
    });
  }
  renderIndexPatternHelpText() {
    const {
      isValidatingIndexPattern,
      hasMatchingIndices
    } = this.props;
    if (!isValidatingIndexPattern && hasMatchingIndices) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "success",
        "data-test-subj": "fieldIndexPatternSuccessMessage"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpHasMatchesLabel",
        defaultMessage: "Success! Index pattern has matching indices."
      })));
    }
    let indexPatternValidationStatus;
    if (isValidatingIndexPattern) {
      indexPatternValidationStatus = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpSearchingLabel",
        defaultMessage: "Looking for matching indices..."
      }));
    } else {
      indexPatternValidationStatus = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpMustMatchLabel",
        defaultMessage: "Index pattern must match at least one index that is not a rollup."
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, indexPatternValidationStatus, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpAllowLabel",
      defaultMessage: "Use a wildcard ({asterisk}) to match multiple indices.",
      values: {
        asterisk: /*#__PURE__*/_react.default.createElement("strong", null, "*")
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpDisallowLabel",
      defaultMessage: "Spaces and the characters {characterList} are not allowed.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", null, indexPatternIllegalCharacters)
      }
    })));
  }
  renderCronEditor() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors
    } = this.props;
    const {
      rollupCron,
      cronFrequency,
      isAdvancedCronVisible,
      fieldToPreferredValueMap
    } = fields;
    const {
      rollupCron: errorRollupCron
    } = fieldErrors;
    if (isAdvancedCronVisible) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.create.stepLogistics.fieldCronLabel",
          defaultMessage: "Cron expression"
        }),
        error: errorRollupCron,
        isInvalid: Boolean(areStepErrorsVisible && errorRollupCron),
        helpText: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation_links.documentationLinks.apis.cronExpressions,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.create.stepLogistics.fieldCron.helpReferenceLinkLabel",
          defaultMessage: "Learn more about cron expressions"
        }))),
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        autoFocus: this.state.cronFocus,
        value: rollupCron,
        onChange: e => onFieldsChange({
          rollupCron: e.target.value
        }),
        isInvalid: Boolean(areStepErrorsVisible && errorRollupCron),
        fullWidth: true,
        "data-test-subj": "rollupAdvancedCron"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: this.hideAdvancedCron
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionSchedule.buttonBasicLabel",
        defaultMessage: "Create basic interval"
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.CronEditor, {
      autoFocus: this.state.cronFocus,
      fieldToPreferredValueMap: fieldToPreferredValueMap,
      cronExpression: rollupCron,
      frequency: cronFrequency,
      onChange: ({
        cronExpression,
        frequency,
        fieldToPreferredValueMap
      }) => onFieldsChange({
        rollupCron: cronExpression,
        simpleRollupCron: cronExpression,
        cronFrequency: frequency,
        fieldToPreferredValueMap
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.showAdvancedCron,
      "data-test-subj": "rollupShowAdvancedCronLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.sectionSchedule.buttonAdvancedLabel",
      defaultMessage: "Create cron expression"
    }))));
  }
  render() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors,
      isValidatingIndexPattern,
      indexPatternAsyncErrors
    } = this.props;
    const {
      id,
      indexPattern,
      rollupIndex,
      rollupPageSize,
      rollupDelay
    } = fields;
    const {
      id: errorId,
      indexPattern: errorIndexPattern,
      rollupIndex: errorRollupIndex,
      rollupPageSize: errorRollupPageSize,
      rollupDelay: errorRollupDelay
    } = fieldErrors;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateLogisticsTitle"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogisticsTitle",
      defaultMessage: "Logistics"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.logisticsDescription",
      defaultMessage: "Define how to run the rollup job and when to index the documents."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: _documentation_links.documentationLinks.apis.createRollupJobsRequest,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "rollupJobCreateLogisticsDocsButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.readDocsButtonLabel",
      defaultMessage: "Logistics docs"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionIdTitle",
        defaultMessage: "Name"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionIdDescription",
        defaultMessage: "This name will be used as a unique identifier for this rollup job."
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIdLabel",
        defaultMessage: "Name"
      }),
      error: errorId,
      isInvalid: Boolean(areStepErrorsVisible && errorId),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: Boolean(areStepErrorsVisible && errorId),
      value: id,
      onChange: e => onFieldsChange({
        id: e.target.value
      }),
      fullWidth: true,
      "data-test-subj": "rollupJobName"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDataFlowTitle",
        defaultMessage: "Data flow"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDataFlowDescription",
        defaultMessage: "Which indices do you want to roll up and where do you want to store the data?"
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPatternLabel",
        defaultMessage: "Index pattern"
      }),
      error: isValidatingIndexPattern ? undefined : errorIndexPattern || indexPatternAsyncErrors,
      isInvalid: Boolean(areStepErrorsVisible && errorIndexPattern) || Boolean(indexPatternAsyncErrors),
      helpText: this.renderIndexPatternHelpText(),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: indexPattern,
      onChange: e => onFieldsChange({
        indexPattern: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorIndexPattern) || Boolean(indexPatternAsyncErrors),
      isLoading: isValidatingIndexPattern,
      fullWidth: true,
      "data-test-subj": "rollupIndexPattern"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldRollupIndexLabel",
        defaultMessage: "Rollup index name"
      }),
      error: errorRollupIndex,
      isInvalid: Boolean(areStepErrorsVisible && errorRollupIndex),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldRollupIndex.helpDisallowLabel",
        defaultMessage: "Spaces, commas, and the characters {characterList} are not allowed.",
        values: {
          characterList: /*#__PURE__*/_react.default.createElement("strong", null, indexIllegalCharacters)
        }
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: rollupIndex,
      onChange: e => onFieldsChange({
        rollupIndex: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorRollupIndex),
      fullWidth: true,
      "data-test-subj": "rollupIndexName"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionScheduleTitle",
        defaultMessage: "Schedule"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionScheduleDescription",
        defaultMessage: "How often do you want to roll up the data?"
      }),
      fullWidth: true
    }, this.renderCronEditor()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionPageSizeTitle",
        defaultMessage: "How many documents do you want to roll up at a time?"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionPageSizeDescription",
        defaultMessage: "A larger page size will roll up data quicker, but requires more memory."
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldPageSizeLabel",
        defaultMessage: "Page size"
      }),
      error: errorRollupPageSize,
      isInvalid: Boolean(areStepErrorsVisible && errorRollupPageSize),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: rollupPageSize ? Number(rollupPageSize) : '',
      onChange: e => onFieldsChange({
        rollupPageSize: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorRollupPageSize),
      fullWidth: true,
      min: 0,
      "data-test-subj": "rollupPageSize"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDelayTitle",
        defaultMessage: "How long should the rollup job wait before rolling up new data?"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDelayDescription",
        defaultMessage: "A latency buffer will delay rolling up data. This will yield a higher-fidelity rollup by allowing for variable ingest latency. By default, the rollup job attempts to roll up all data that is available."
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldDelayLabel",
        defaultMessage: "Latency buffer (optional)"
      }),
      error: errorRollupDelay,
      isInvalid: Boolean(areStepErrorsVisible && errorRollupDelay),
      helpText: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldDelay.helpExampleLabel",
        defaultMessage: "Example values: 30s, 20m, 24h, 2d, 1w, 1M"
      }))),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: rollupDelay || '',
      onChange: e => onFieldsChange({
        rollupDelay: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorRollupDelay),
      fullWidth: true,
      "data-test-subj": "rollupDelay"
    })))), this.renderErrors());
  }
}
exports.StepLogistics = StepLogistics;
(0, _defineProperty2.default)(StepLogistics, "propTypes", {
  fields: _propTypes.default.object.isRequired,
  onFieldsChange: _propTypes.default.func.isRequired,
  fieldErrors: _propTypes.default.object.isRequired,
  hasErrors: _propTypes.default.bool.isRequired,
  areStepErrorsVisible: _propTypes.default.bool.isRequired,
  isValidatingIndexPattern: _propTypes.default.bool.isRequired,
  hasMatchingIndices: _propTypes.default.bool.isRequired,
  indexPatternAsyncErrors: _propTypes.default.array
});