"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductDocBasePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _path = _interopRequireDefault(require("path"));
var _utils = require("@kbn/utils");
var _server = require("@kbn/core/server");
var _consts = require("../common/consts");
var _saved_objects = require("./saved_objects");
var _package_installer = require("./services/package_installer");
var _doc_install_status = require("./services/doc_install_status");
var _doc_manager = require("./services/doc_manager");
var _search = require("./services/search");
var _routes = require("./routes");
var _tasks = require("./tasks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductDocBasePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "internalServices", void 0);
    this.context = context;
    this.logger = context.logger.get();
  }
  setup(coreSetup, {
    taskManager
  }) {
    const getServices = () => {
      if (!this.internalServices) {
        throw new Error('getServices called before #start');
      }
      return this.internalServices;
    };
    coreSetup.savedObjects.registerType(_saved_objects.productDocInstallStatusSavedObjectType);
    (0, _tasks.registerTaskDefinitions)({
      taskManager,
      getServices
    });
    const router = coreSetup.http.createRouter();
    (0, _routes.registerRoutes)({
      router,
      getServices
    });
    return {};
  }
  start(core, {
    licensing,
    taskManager
  }) {
    const soClient = new _server.SavedObjectsClient(core.savedObjects.createInternalRepository([_consts.productDocInstallStatusSavedObjectTypeName]));
    const productDocClient = new _doc_install_status.ProductDocInstallClient({
      soClient,
      log: this.logger
    });
    const packageInstaller = new _package_installer.PackageInstaller({
      esClient: core.elasticsearch.client.asInternalUser,
      productDocClient,
      kibanaVersion: this.context.env.packageInfo.version,
      artifactsFolder: _path.default.join((0, _utils.getDataPath)(), 'ai-kb-artifacts'),
      artifactRepositoryUrl: this.context.config.get().artifactRepositoryUrl,
      elserInferenceId: this.context.config.get().elserInferenceId,
      logger: this.logger.get('package-installer')
    });
    const searchService = new _search.SearchService({
      esClient: core.elasticsearch.client.asInternalUser,
      logger: this.logger.get('search-service')
    });
    const documentationManager = new _doc_manager.DocumentationManager({
      logger: this.logger.get('doc-manager'),
      docInstallClient: productDocClient,
      licensing,
      taskManager,
      auditService: core.security.audit
    });
    this.internalServices = {
      logger: this.logger,
      packageInstaller,
      installClient: productDocClient,
      documentationManager,
      licensing,
      taskManager
    };
    documentationManager.updateAll().catch(err => {
      this.logger.error(`Error scheduling product documentation updateAll task: ${err.message}`);
    });
    return {
      management: {
        install: documentationManager.install.bind(documentationManager),
        update: documentationManager.update.bind(documentationManager),
        updateAll: documentationManager.updateAll.bind(documentationManager),
        uninstall: documentationManager.uninstall.bind(documentationManager),
        getStatus: documentationManager.getStatus.bind(documentationManager)
      },
      search: searchService.search.bind(searchService)
    };
  }
}
exports.ProductDocBasePlugin = ProductDocBasePlugin;