"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnBasePalette = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class KbnBasePalette {
  constructor({
    id,
    name,
    tag,
    colorCount,
    aliases = [],
    legacy = false,
    standalone = false
  }) {
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "tag", void 0);
    (0, _defineProperty2.default)(this, "colorCount", void 0);
    (0, _defineProperty2.default)(this, "legacy", void 0);
    (0, _defineProperty2.default)(this, "standalone", void 0);
    (0, _defineProperty2.default)(this, "aliases", void 0);
    (0, _defineProperty2.default)(this, "getColor", (colorIndex, numberOfColors) => {
      const colors = this.colors(numberOfColors);
      return colors[colorIndex % colors.length]; // ensure color is always returned
    });
    this.id = id;
    this.name = name;
    this.tag = tag;
    this.colorCount = colorCount;
    this.legacy = legacy;
    this.standalone = standalone;
    this.aliases = aliases;
  }
}
exports.KbnBasePalette = KbnBasePalette;