"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lastStepExecutionResult = exports.lastPlanningResult = exports.isStepExecutionResult = exports.isPlanningResult = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isPlanningResult = item => {
  return 'steps' in item && 'reasoning' in item;
};
exports.isPlanningResult = isPlanningResult;
const isStepExecutionResult = item => {
  return 'step' in item && 'output' in item;
};
exports.isStepExecutionResult = isStepExecutionResult;
const lastPlanningResult = backlog => {
  for (let i = backlog.length - 1; i >= 0; i--) {
    const current = backlog[i];
    if (isPlanningResult(current)) {
      return current;
    }
  }
  throw new Error('No reflection result found');
};
exports.lastPlanningResult = lastPlanningResult;
const lastStepExecutionResult = backlog => {
  for (let i = backlog.length - 1; i >= 0; i--) {
    const current = backlog[i];
    if (isStepExecutionResult(current)) {
      return current;
    }
  }
  throw new Error('No reflection result found');
};
exports.lastStepExecutionResult = lastStepExecutionResult;