"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnechatTools = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_onechat_service = require("./use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOnechatTools = () => {
  var _data$tools;
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data,
    isLoading,
    error
  } = (0, _reactQuery.useQuery)({
    queryKey: ['tools', 'list'],
    queryFn: () => toolsService.list()
  });
  return {
    tools: (_data$tools = data === null || data === void 0 ? void 0 : data.tools) !== null && _data$tools !== void 0 ? _data$tools : [],
    isLoading,
    error
  };
};
exports.useOnechatTools = useOnechatTools;