"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unitToSeconds = unitToSeconds;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDurationAsSeconds(value, unitOfTime) {
  return _moment.default.duration(value, unitOfTime).asSeconds();
}
const units = {
  ms: getDurationAsSeconds(1, 'millisecond'),
  s: getDurationAsSeconds(1, 'second'),
  m: getDurationAsSeconds(1, 'minute'),
  h: getDurationAsSeconds(1, 'hour'),
  d: getDurationAsSeconds(1, 'day'),
  w: getDurationAsSeconds(1, 'week'),
  M: getDurationAsSeconds(1, 'month'),
  y: getDurationAsSeconds(1, 'year')
};
function unitToSeconds(unit) {
  return units[unit];
}