"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavControlScope = useNavControlScope;
var _react = require("react");
var _aiAssistant = require("@kbn/ai-assistant");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/core/public");
var _lodash = require("lodash");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scopeUrlLookup = {
  [_public.DEFAULT_APP_CATEGORIES.observability.id]: ['observability'],
  [_public.DEFAULT_APP_CATEGORIES.enterpriseSearch.id]: ['search']
};
function useNavControlScope() {
  const service = (0, _aiAssistant.useAIAssistantAppService)();
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const currentApplication = (0, _useObservable.default)(application.currentAppId$);
  const applications = (0, _useObservable.default)(application.applications$);
  (0, _react.useEffect)(() => {
    var _applications$get, _applications$get$cat;
    const currentCategoryId = currentApplication && (applications === null || applications === void 0 ? void 0 : (_applications$get = applications.get(currentApplication)) === null || _applications$get === void 0 ? void 0 : (_applications$get$cat = _applications$get.category) === null || _applications$get$cat === void 0 ? void 0 : _applications$get$cat.id) || _public.DEFAULT_APP_CATEGORIES.kibana.id;
    const newScopes = scopeUrlLookup[currentCategoryId];
    if (newScopes !== null && newScopes !== void 0 && newScopes.length && !(0, _lodash.isEqual)(service.getScopes(), newScopes)) {
      service.setScopes(newScopes);
    }
  }, [applications, currentApplication, service]);
}