"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedIndex = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _index_detail_status = require("../index_detail_status");
var _chart = require("../../chart");
var _i18nReact = require("@kbn/i18n-react");
var _callout = require("../../../alerts/callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedIndex = ({
  indexSummary,
  metrics,
  alerts,
  ...props
}) => {
  const metricsToShow = [metrics.index_3, metrics.index_4, metrics.index_total, metrics.index_time, metrics.index_refresh, metrics.index_throttling, metrics.index_disk, metrics.index_segment_count, metrics.index_latency];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.index.advanced.heading",
    defaultMessage: "Elasticsearch index advanced view"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_index_detail_status.IndexDetailStatus, {
    stats: indexSummary,
    alerts: alerts
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_callout.AlertsCallout, {
    alerts: alerts
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, metricsToShow.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric
  }, props)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))))));
};
exports.AdvancedIndex = AdvancedIndex;