"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLocalStorage = void 0;
var _react = require("react");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLocalStorage = (key, defaultValue) => {
  const localStorageMonitoringKey = 'xpack.monitoring.data';
  const getMonitoringDataStorage = () => {
    const monitoringDataStorage = window.localStorage.getItem(localStorageMonitoringKey);
    let parsedData = {};
    try {
      parsedData = monitoringDataStorage && JSON.parse(monitoringDataStorage) || {};
    } catch (e) {
      throw new Error('Monitoring UI: error parsing locally stored monitoring data');
    }
    return parsedData;
  };
  const saveToStorage = value => {
    const monitoringDataObj = getMonitoringDataStorage();
    monitoringDataObj[key] = value;
    window.localStorage.setItem(localStorageMonitoringKey, JSON.stringify(monitoringDataObj));
  };
  const getFromStorage = () => {
    const monitoringDataObj = getMonitoringDataStorage();
    if ((0, _lodash.has)(monitoringDataObj, key)) {
      return monitoringDataObj[key];
    }
  };
  const storedItem = getFromStorage();
  if (!storedItem) {
    saveToStorage(defaultValue);
  }
  const toStore = storedItem || defaultValue;
  const [item, setItem] = (0, _react.useState)(toStore);
  const saveItem = value => {
    saveToStorage(value);
    setItem(value);
  };
  return [item, saveItem];
};
exports.useLocalStorage = useLocalStorage;