"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricViewerTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _kibana = require("../../contexts/kibana");
var _timeseriesexplorer_help_popover = require("../timeseriesexplorer_help_popover");
var _triggers = require("../../../ui_actions/triggers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterButton = ({
  api,
  entity,
  operation
}) => {
  const {
    services: {
      uiActions
    }
  } = (0, _kibana.useMlKibana)();
  const isAddFilter = operation === _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD;
  const onClick = (0, _react.useCallback)(() => {
    const trigger = uiActions.getTrigger(_triggers.SINGLE_METRIC_VIEWER_ENTITY_FIELD_SELECTION_TRIGGER);
    trigger.exec({
      embeddable: api,
      data: [{
        ...entity,
        operation: isAddFilter ? _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD : _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.REMOVE
      }]
    });
  }, [api, entity, isAddFilter, uiActions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isAddFilter ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.title.addFilterTooltip",
      defaultMessage: "Filter for"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.title.addNegateFilterTooltip",
      defaultMessage: "Filter out"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    onClick: onClick,
    iconType: isAddFilter ? 'plusInCircle' : 'minusInCircle',
    "aria-label": isAddFilter ? _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.title.addFilterAriaLabel', {
      defaultMessage: 'Filter for'
    }) : _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.title.addNegateFilterAriaLabel', {
      defaultMessage: 'Filter out'
    })
  }));
};
const SingleMetricViewerTitle = ({
  api,
  entityData,
  functionLabel
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.singleTimeSeriesAnalysisTitle', {
    defaultMessage: 'Single time series analysis of {functionLabel}',
    values: {
      functionLabel
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_help_popover.TimeSeriesExplorerHelpPopover, {
    embeddableMode: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, entityData.entities.map((entity, i) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: `${entity.fieldName}.${entity.fieldValue}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "accentSecondary",
      component: "span"
    }, `${entity.fieldName}: ${entity.fieldValue}`)), api !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(FilterButton, {
      api: api,
      entity: entity,
      operation: _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(FilterButton, {
      api: api,
      entity: entity,
      operation: _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.REMOVE
    }))) : null));
  }))));
};
exports.SingleMetricViewerTitle = SingleMetricViewerTitle;