"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQuestionAnsweringOutputComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON_PADDING = '2px';
const TRIM_CHAR_COUNT = 200;
const getQuestionAnsweringOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(QuestionAnsweringOutput, {
  inferrer: inferrer
});
exports.getQuestionAnsweringOutputComponent = getQuestionAnsweringOutputComponent;
const QuestionAnsweringOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, result.map(({
    response,
    inputText
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, insertHighlighting(response[0], inputText)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))));
};
function insertHighlighting(result, inputText) {
  const start = inputText.slice(0, result.startOffset);
  const end = inputText.slice(result.endOffset, inputText.length);
  const truncatedStart = start.length > TRIM_CHAR_COUNT ? `...${start.slice(start.length - TRIM_CHAR_COUNT, start.length)}` : start;
  const truncatedEnd = end.length > TRIM_CHAR_COUNT ? `${end.slice(0, TRIM_CHAR_COUNT)}...` : end;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      lineHeight: '24px'
    }
  }, truncatedStart, /*#__PURE__*/_react.default.createElement(ResultBadge, null, result.value), truncatedEnd);
}
const ResultBadge = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs').fontSize;
  const isAmsterdam = euiTheme.themeName === 'EUI_THEME_AMSTERDAM';

  // For Amsterdam, use a `behindText` variant. Borealis doesn't need it because of updated contrasts.
  const badgeColor = isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText5 : euiTheme.colors.vis.euiColorVis9;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor,
    style: {
      marginRight: ICON_PADDING,
      marginTop: `-${ICON_PADDING}`,
      // For Amsterdam, add a border to the badge to improve contrast with the background.
      ...(isAmsterdam ? {
        border: `1px solid ${euiTheme.colors.vis.euiColorVis5}`
      } : {}),
      fontSize: euiFontSizeXS,
      padding: '0px 6px',
      pointerEvents: 'none'
    }
  }, children);
};