"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricJobCreator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _job_creator = require("./job_creator");
var _default_configs = require("./util/default_configs");
var _new_job = require("../../../../../../common/constants/new_job");
var _general = require("./util/general");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SingleMetricJobCreator extends _job_creator.JobCreator {
  constructor(mlApi, newJobCapsService, indexPattern, savedSearch, query) {
    super(mlApi, newJobCapsService, indexPattern, savedSearch, query);
    (0, _defineProperty2.default)(this, "_type", _new_job.JOB_TYPE.SINGLE_METRIC);
    this.createdBy = _new_job.CREATED_BY_LABEL.SINGLE_METRIC;
    this._wizardInitialized$.next(true);
  }

  // only a single detector exists for this job type
  // therefore _addDetector and _editDetector merge into this
  // single setDetector function
  setDetector(agg, field) {
    const dtr = (0, _default_configs.createBasicDetector)(agg, field);
    if (this._detectors.length === 0) {
      this._addDetector(dtr, agg, field);
    } else {
      this._editDetector(dtr, agg, field, 0);
    }
    this._createDatafeedAggregations();
  }
  set bucketSpan(bucketSpan) {
    this._job_config.analysis_config.bucket_span = bucketSpan;
    this._setBucketSpanMs(bucketSpan);
    this._createDatafeedAggregations();
  }

  // overriding set means we need to override get too
  // JS doesn't do inheritance very well
  get bucketSpan() {
    return this._job_config.analysis_config.bucket_span;
  }

  // aggregations need to be recreated whenever the detector or bucket_span change
  _createDatafeedAggregations() {
    if (this._detectors.length && typeof this._job_config.analysis_config.bucket_span === 'string' && this._aggs.length > 0) {
      var _this$_fields$;
      delete this._job_config.analysis_config.summary_count_field_name;
      delete this._datafeed_config.aggregations;

      // if the selected field is called doc_count, we cannot use aggregations
      if (((_this$_fields$ = this._fields[0]) === null || _this$_fields$ === void 0 ? void 0 : _this$_fields$.name) === _mlAnomalyUtils.DOC_COUNT) {
        return;
      }
      const functionName = this._aggs[0].dslName;
      const timeField = this._job_config.data_description.time_field;
      const duration = (0, _mlParseInterval.parseInterval)(this._job_config.analysis_config.bucket_span, true);
      if (duration === null) {
        return;
      }
      const bucketSpanSeconds = duration.asSeconds();
      const interval = bucketSpanSeconds * 1000;
      let field = null;
      switch (functionName) {
        case _mlAnomalyUtils.ES_AGGREGATION.COUNT:
          this._job_config.analysis_config.summary_count_field_name = _mlAnomalyUtils.DOC_COUNT;
          this._datafeed_config.aggregations = {
            buckets: {
              date_histogram: {
                field: timeField,
                fixed_interval: `${interval}ms`
              },
              aggregations: {
                [timeField]: {
                  max: {
                    field: timeField
                  }
                }
              }
            }
          };
          break;
        case _mlAnomalyUtils.ES_AGGREGATION.AVG:
        // TODO - fix median aggregations
        // case ES_AGGREGATION.PERCENTILES:
        case _mlAnomalyUtils.ES_AGGREGATION.SUM:
        case _mlAnomalyUtils.ES_AGGREGATION.MIN:
        case _mlAnomalyUtils.ES_AGGREGATION.MAX:
          field = this._fields[0];
          if (field !== null) {
            const fieldName = field.name;
            this._job_config.analysis_config.summary_count_field_name = _mlAnomalyUtils.DOC_COUNT;
            this._datafeed_config.aggregations = {
              buckets: {
                date_histogram: {
                  field: timeField,
                  fixed_interval: `${interval * 0.1}ms` // use 10% of bucketSpan to allow for better sampling
                },
                aggregations: {
                  [fieldName]: {
                    [functionName]: {
                      field: fieldName
                    }
                  },
                  [timeField]: {
                    max: {
                      field: timeField
                    }
                  }
                }
              }
            };
          }
          break;
        case _mlAnomalyUtils.ES_AGGREGATION.CARDINALITY:
          field = this._fields[0];
          if (field !== null) {
            const fieldName = field.name;
            this._job_config.analysis_config.summary_count_field_name = `dc_${fieldName}`;
            this._datafeed_config.aggregations = {
              buckets: {
                date_histogram: {
                  field: timeField,
                  fixed_interval: `${interval}ms`
                },
                aggregations: {
                  [timeField]: {
                    max: {
                      field: timeField
                    }
                  },
                  [this._job_config.analysis_config.summary_count_field_name]: {
                    [functionName]: {
                      field: fieldName
                    }
                  }
                }
              }
            };
            const dtr = this._detectors[0];
            // finally, modify the detector before saving
            dtr.function = _mlAnomalyUtils.ML_JOB_AGGREGATION.NON_ZERO_COUNT;
            // add a description using the original function name rather 'non_zero_count'
            // as the user may not be aware it's been changed
            dtr.detector_description = `${functionName} (${fieldName})`;
            delete dtr.field_name;
          }
          break;
        default:
          break;
      }
    }
  }
  get aggFieldPair() {
    if (this._aggs.length === 0) {
      return null;
    } else {
      return {
        agg: this._aggs[0],
        field: this._fields[0]
      };
    }
  }
  cloneFromExistingJob(job, datafeed) {
    this._overrideConfigs(job, datafeed);
    this.createdBy = _new_job.CREATED_BY_LABEL.SINGLE_METRIC;
    this._sparseData = (0, _general.isSparseDataJob)(job, datafeed);
    const detectors = (0, _general.getRichDetectors)(this.newJobCapsService, job, datafeed, this.additionalFields, false);
    this.removeAllDetectors();
    const dtr = detectors[0];
    if (detectors.length && dtr.agg !== null && dtr.field !== null) {
      this.setDetector(dtr.agg, dtr.field);
    }
  }
}
exports.SingleMetricJobCreator = SingleMetricJobCreator;