"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluatePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../../../../contexts/kibana");
var _common = require("../../../../common");
var _analytics = require("../../../../common/analytics");
var _expandable_section = require("../expandable_section");
var _evaluate_stat = require("./evaluate_stat");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_STATS = {
  mse: _analytics.EMPTY_STAT,
  msle: _analytics.EMPTY_STAT,
  huber: _analytics.EMPTY_STAT,
  rSquared: _analytics.EMPTY_STAT
};
const defaultEval = {
  ...EMPTY_STATS,
  error: null
};
const EvaluatePanel = ({
  jobConfig,
  jobStatus,
  searchQuery
}) => {
  var _jobConfig$dest$resul;
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const docLink = docLinks.links.ml.regressionEvaluation;
  const [trainingEval, setTrainingEval] = (0, _react.useState)(defaultEval);
  const [generalizationEval, setGeneralizationEval] = (0, _react.useState)(defaultEval);
  const [isLoadingTraining, setIsLoadingTraining] = (0, _react.useState)(false);
  const [isLoadingGeneralization, setIsLoadingGeneralization] = (0, _react.useState)(false);
  const [isTrainingFilter, setIsTrainingFilter] = (0, _react.useState)(undefined);
  const [trainingDocsCount, setTrainingDocsCount] = (0, _react.useState)(null);
  const [generalizationDocsCount, setGeneralizationDocsCount] = (0, _react.useState)(null);
  const index = jobConfig.dest.index;
  const dependentVariable = (0, _mlDataFrameAnalyticsUtils.getDependentVar)(jobConfig.analysis);
  const predictionFieldName = (0, _mlDataFrameAnalyticsUtils.getPredictionFieldName)(jobConfig.analysis);
  // default is 'ml'
  const resultsField = (_jobConfig$dest$resul = jobConfig.dest.results_field) !== null && _jobConfig$dest$resul !== void 0 ? _jobConfig$dest$resul : 'ml';
  const loadGeneralizationData = async (ignoreDefaultQuery = true) => {
    setIsLoadingGeneralization(true);
    const genErrorEval = await (0, _common.loadEvalData)({
      mlApi,
      isTraining: false,
      index,
      dependentVariable,
      resultsField,
      predictionFieldName,
      searchQuery,
      ignoreDefaultQuery,
      jobType: _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION
    });
    if (genErrorEval.success === true && genErrorEval.eval && (0, _analytics.isRegressionEvaluateResponse)(genErrorEval.eval)) {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      const {
        mse,
        msle,
        huber,
        r_squared
      } = (0, _common.getValuesFromResponse)(genErrorEval.eval);
      setGeneralizationEval({
        mse,
        msle,
        huber,
        rSquared: r_squared,
        error: null
      });
      setIsLoadingGeneralization(false);
    } else {
      setIsLoadingGeneralization(false);
      setGeneralizationEval({
        ...EMPTY_STATS,
        error: genErrorEval.error
      });
    }
  };
  const loadTrainingData = async (ignoreDefaultQuery = true) => {
    setIsLoadingTraining(true);
    const trainingErrorEval = await (0, _common.loadEvalData)({
      mlApi,
      isTraining: true,
      index,
      dependentVariable,
      resultsField,
      predictionFieldName,
      searchQuery,
      ignoreDefaultQuery,
      jobType: _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION
    });
    if (trainingErrorEval.success === true && trainingErrorEval.eval && (0, _analytics.isRegressionEvaluateResponse)(trainingErrorEval.eval)) {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      const {
        mse,
        msle,
        huber,
        r_squared
      } = (0, _common.getValuesFromResponse)(trainingErrorEval.eval);
      setTrainingEval({
        mse,
        msle,
        huber,
        rSquared: r_squared,
        error: null
      });
      setIsLoadingTraining(false);
    } else {
      setIsLoadingTraining(false);
      setTrainingEval({
        ...EMPTY_STATS,
        error: trainingErrorEval.error
      });
    }
  };
  const loadData = async () => {
    loadGeneralizationData(false);
    const genDocsCountResp = await (0, _common.loadDocsCount)({
      mlApi,
      ignoreDefaultQuery: false,
      isTraining: false,
      searchQuery,
      resultsField,
      destIndex: jobConfig.dest.index
    });
    if (genDocsCountResp.success === true) {
      setGeneralizationDocsCount(genDocsCountResp.docsCount);
    } else {
      setGeneralizationDocsCount(null);
    }
    loadTrainingData(false);
    const trainDocsCountResp = await (0, _common.loadDocsCount)({
      mlApi,
      ignoreDefaultQuery: false,
      isTraining: true,
      searchQuery,
      resultsField,
      destIndex: jobConfig.dest.index
    });
    if (trainDocsCountResp.success === true) {
      setTrainingDocsCount(trainDocsCountResp.docsCount);
    } else {
      setTrainingDocsCount(null);
    }
  };
  (0, _react.useEffect)(() => {
    let isTraining;
    const query = (0, _analytics.isResultsSearchBoolQuery)(searchQuery) && (searchQuery.bool.should || searchQuery.bool.filter);
    if (query !== undefined && query !== false) {
      for (let i = 0; i < query.length; i++) {
        const clause = query[i];
        if (clause.match && clause.match[`${resultsField}.is_training`] !== undefined) {
          isTraining = clause.match[`${resultsField}.is_training`];
          break;
        } else if (clause.bool && (clause.bool.should !== undefined || clause.bool.filter !== undefined)) {
          const innerQuery = clause.bool.should || clause.bool.filter;
          if (innerQuery !== undefined) {
            for (let j = 0; j < innerQuery.length; j++) {
              const innerClause = innerQuery[j];
              if (innerClause.match && innerClause.match[`${resultsField}.is_training`] !== undefined) {
                isTraining = innerClause.match[`${resultsField}.is_training`];
                break;
              }
            }
          }
        }
      }
    }
    setIsTrainingFilter(isTraining);
    loadData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(searchQuery)]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    urlStateKey: 'evaluation',
    dataTestId: "RegressionEvaluation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.evaluateSectionTitle",
      defaultMessage: "Model evaluation"
    }),
    docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      iconType: "question",
      iconSide: "left",
      size: "xs",
      color: "primary",
      href: docLink
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.regressionDocsLink",
      defaultMessage: "Regression evaluation docs "
    }))),
    headerItems: jobStatus !== undefined ? [{
      id: 'jobStatus',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateJobStatusLabel', {
        defaultMessage: 'Job status'
      }),
      value: jobStatus
    }] : [],
    contentPadding: true,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.generalizationErrorTitle', {
      defaultMessage: 'Generalization error'
    }))), generalizationDocsCount !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.generalizationDocsCount",
      defaultMessage: "{docsCount, plural, one {# doc} other {# docs}} evaluated",
      values: {
        docsCount: generalizationDocsCount
      }
    }), isTrainingFilter === true && generalizationDocsCount === 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.generalizationFilterText",
      defaultMessage: ". Filtering for training data."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenMSEstat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.mse,
      statType: _analytics.REGRESSION_STATS.MSE
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenRSquaredStat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.rSquared,
      statType: _analytics.REGRESSION_STATS.R_SQUARED
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenMsleStat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.msle,
      statType: _analytics.REGRESSION_STATS.MSLE
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionGenHuberStat',
      isLoading: isLoadingGeneralization,
      title: generalizationEval.huber,
      statType: _analytics.REGRESSION_STATS.HUBER
    })))))), generalizationEval.error !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger"
    }, isTrainingFilter === true && generalizationDocsCount === 0 && generalizationEval.error.includes('No documents found') ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.evaluateNoTestingDocsError', {
      defaultMessage: 'No testing documents found'
    }) : generalizationEval.error)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.trainingErrorTitle', {
      defaultMessage: 'Training error'
    }))), trainingDocsCount !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.trainingDocsCount",
      defaultMessage: "{docsCount, plural, one {# doc} other {# docs}} evaluated",
      values: {
        docsCount: trainingDocsCount
      }
    }), isTrainingFilter === false && trainingDocsCount === 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.regressionExploration.trainingFilterText",
      defaultMessage: ". Filtering for testing data."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingMSEstat',
      isLoading: isLoadingTraining,
      title: trainingEval.mse,
      statType: _analytics.REGRESSION_STATS.MSE
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingRSquaredStat',
      isLoading: isLoadingTraining,
      title: trainingEval.rSquared,
      statType: _analytics.REGRESSION_STATS.R_SQUARED
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingMsleStat',
      isLoading: isLoadingTraining,
      title: trainingEval.msle,
      statType: _analytics.REGRESSION_STATS.MSLE
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAnalyticsRegressionTrainingHuberStat',
      isLoading: isLoadingTraining,
      title: trainingEval.huber,
      statType: _analytics.REGRESSION_STATS.HUBER
    })))))), trainingEval.error !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger"
    }, isTrainingFilter === false && trainingDocsCount === 0 && trainingEval.error.includes('No documents found') ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.evaluateNoTrainingDocsError', {
      defaultMessage: 'No training documents found'
    }) : trainingEval.error)))))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.EvaluatePanel = EvaluatePanel;