"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Warning = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _cloud = require("../../../../common/constants/cloud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Warning = ({
  size,
  isCloud,
  isCloudTrial,
  deploymentId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: size,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.nodeAvailableWarning.noMLNodesAvailableTitle",
      defaultMessage: "No ML nodes available"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.nodeAvailableWarning.noMLNodesAvailableDescription",
    defaultMessage: "There are no ML nodes available."
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.nodeAvailableWarning.unavailableCreateOrRunJobsDescription",
    defaultMessage: "You will not be able to create or run jobs."
  })), isCloud && deploymentId !== null && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.nodeAvailableWarning.linkToCloudDescription",
    defaultMessage: "Please edit your {link}. You may enable a free {maxRamForMLNodes} machine learning node or expand your existing ML configuration.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: `https://cloud.elastic.co/deployments?q=${deploymentId}`
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.nodeAvailableWarning.linkToCloud.hereLinkText",
        defaultMessage: "Elastic Cloud deployment"
      })),
      maxRamForMLNodes: isCloudTrial ? _cloud.TRIAL_MAX_RAM_FOR_ML_NODES : _cloud.PLATINUM_MAX_RAM_FOR_ML_NODES
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.Warning = Warning;