"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const [INFO, WARNING, ERROR] = ['info', 'warning', 'error'];
const JobIcon = ({
  message,
  showTooltip = false
}) => {
  if (message === undefined) {
    return /*#__PURE__*/_react.default.createElement("span", null);
  }
  let color = 'primary';
  let icon = 'warning';
  if (message.level === INFO) {
    icon = 'info';
  } else if (message.level === WARNING) {
    color = 'warning';
  } else if (message.level === ERROR) {
    color = 'danger';
  }
  if (showTooltip) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: message.text,
      position: "bottom",
      type: icon,
      color: color
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon,
      color: color
    });
  }
};
exports.JobIcon = JobIcon;