"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaskEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _panel_strings = require("../../../connected_components/panel_strings");
var _mask = require("../../../classes/layers/vector_layer/mask");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const operatorOptions = [{
  value: _constants.MASK_OPERATOR.BELOW,
  text: _mask.BELOW
}, {
  value: _constants.MASK_OPERATOR.ABOVE,
  text: _mask.ABOVE
}];
class MaskEditor extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onSet", () => {
      if (this._isValueInValid()) {
        return;
      }
      this.props.onChange({
        ...this.props.metric,
        mask: {
          operator: this.state.operator,
          value: this.state.value
        }
      });
      this.props.onClose();
    });
    (0, _defineProperty2.default)(this, "_onClear", () => {
      const newMetric = {
        ...this.props.metric
      };
      delete newMetric.mask;
      this.props.onChange(newMetric);
      this.props.onClose();
    });
    (0, _defineProperty2.default)(this, "_onOperatorChange", e => {
      this.setState({
        operator: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onValueChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        value: isNaN(sanitizedValue) ? evt.target.value : sanitizedValue
      });
    });
    this.state = {
      operator: this.props.metric.mask !== undefined ? this.props.metric.mask.operator : _constants.MASK_OPERATOR.BELOW,
      value: this.props.metric.mask !== undefined ? this.props.metric.mask.value : ''
    };
  }
  _hasChanges() {
    return this.props.metric.mask === undefined || this.props.metric.mask.operator !== this.state.operator || this.props.metric.mask.value !== this.state.value;
  }
  _isValueInValid() {
    return typeof this.state.value === 'string';
  }
  _renderForm() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      id: "maskOperatorSelect",
      options: operatorOptions,
      value: this.state.operator,
      onChange: this._onOperatorChange,
      "aria-label": _i18n.i18n.translate('xpack.maps.maskEditor.operatorSelectLabel', {
        defaultMessage: 'Mask operator select'
      })
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: this.state.value,
      onChange: this._onValueChange,
      "aria-label": _i18n.i18n.translate('xpack.maps.maskEditor.valueInputLabel', {
        defaultMessage: 'Mask value input'
      })
    }))));
  }
  _renderFooter() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.props.onClose,
      size: "s"
    }, _panel_strings.panelStrings.close)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      isDisabled: this.props.metric.mask === undefined,
      onClick: this._onClear,
      size: "s"
    }, _panel_strings.panelStrings.clear)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      isDisabled: this._isValueInValid() || !this._hasChanges(),
      onClick: this._onSet,
      size: "s"
    }, _panel_strings.panelStrings.apply))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this._renderForm(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), this._renderFooter());
  }
}
exports.MaskEditor = MaskEditor;