"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitlesAndTextOptionsPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _shared_components = require("../../../shared_components");
var _title_position_option = require("./title_position_option");
var _text_formatting_options = require("./text_formatting_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TitlesAndTextOptionsPopover = ({
  state,
  setState
}) => {
  return /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('xpack.lens.shared.titlesAndTextLabel', {
      defaultMessage: 'Titles and text'
    }),
    condition: true
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.shared.metric.titlesAndTextLabel', {
      defaultMessage: 'Titles and text'
    }),
    type: "titlesAndText",
    groupPosition: "none",
    buttonDataTestSubj: "lnsTextOptionsButton"
  }, /*#__PURE__*/_react.default.createElement(_text_formatting_options.TextFormattingOptions, {
    state: state,
    setState: setState
  }), /*#__PURE__*/_react.default.createElement(_title_position_option.TitlePositionOptions, {
    state: state,
    setState: setState
  })));
};
exports.TitlesAndTextOptionsPopover = TitlesAndTextOptionsPopover;