"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulletTypes = exports.GaugeToolbar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/expression-gauge-plugin/common");
var _visualizationUtils = require("@kbn/visualization-utils");
var _chartIcons = require("@kbn/chart-icons");
var _shared_components = require("../../../shared_components");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREFIX = `lns_gaugeOrientation_`;
const bulletTypes = exports.bulletTypes = [{
  id: `${PREFIX}horizontalBullet`,
  label: _i18n.i18n.translate('xpack.lens.gauge.bullet.orientantionHorizontal', {
    defaultMessage: 'Horizontal'
  })
}, {
  id: `${PREFIX}verticalBullet`,
  label: _i18n.i18n.translate('xpack.lens.gauge.bullet.orientantionVertical', {
    defaultMessage: 'Vertical'
  })
}];
const CHART_NAMES = {
  horizontalBullet: {
    id: _common.GaugeShapes.HORIZONTAL_BULLET,
    icon: _chartIcons.IconChartLinearSimple,
    label: _i18n.i18n.translate('xpack.lens.gaugeLinear.gaugeLabel', {
      defaultMessage: 'Linear'
    })
  },
  verticalBullet: {
    id: _common.GaugeShapes.VERTICAL_BULLET,
    icon: _chartIcons.IconChartLinearSimple,
    label: _i18n.i18n.translate('xpack.lens.gaugeLinear.gaugeLabel', {
      defaultMessage: 'Linear'
    })
  },
  semiCircle: {
    id: _common.GaugeShapes.SEMI_CIRCLE,
    icon: _chartIcons.IconChartGaugeSemiCircleSimple,
    label: _constants.gaugeTitlesByType.semiCircle
  },
  arc: {
    id: _common.GaugeShapes.ARC,
    icon: _chartIcons.IconChartGaugeArcSimple,
    label: _constants.gaugeTitlesByType.arc
  },
  circle: {
    id: _common.GaugeShapes.CIRCLE,
    icon: _chartIcons.IconChartGaugeCircleSimple,
    label: _constants.gaugeTitlesByType.circle
  }
};
const gaugeShapes = [CHART_NAMES.horizontalBullet, CHART_NAMES.semiCircle, CHART_NAMES.arc, CHART_NAMES.circle];
const GaugeToolbar = exports.GaugeToolbar = /*#__PURE__*/(0, _react.memo)(props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(AppearancePopover, props)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(TitlesAndTextPopover, props)));
});
const AppearancePopover = props => {
  const {
    state,
    setState
  } = props;
  const selectedOption = CHART_NAMES[state.shape];
  const selectedBulletType = bulletTypes.find(({
    id
  }) => id === `${PREFIX}${state.shape}`);
  return /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.gauge.appearanceLabel', {
      defaultMessage: 'Appearance'
    }),
    type: "visualOptions",
    buttonDataTestSubj: "lnsVisualOptionsButton",
    panelStyle: {
      width: '500px'
    },
    "data-test-subj": "lnsVisualOptionsPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.gauge.angleType', {
      defaultMessage: 'Gauge shape'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": "lnsToolbarGaugeAngleType",
    "aria-label": _i18n.i18n.translate('xpack.lens.label.gauge.angleType', {
      defaultMessage: 'Gauge shape'
    }),
    onChange: ([option]) => {
      setState({
        ...state,
        shape: option.value
      });
    },
    isClearable: false,
    options: gaugeShapes.map(({
      id,
      label,
      icon
    }) => ({
      value: id,
      label,
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: icon
      })
    })),
    selectedOptions: [selectedOption],
    singleSelection: {
      asPlainText: true
    },
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: selectedOption.icon
    })
  })), (state.shape === _common.GaugeShapes.HORIZONTAL_BULLET || state.shape === _common.GaugeShapes.VERTICAL_BULLET) && selectedBulletType && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: " "
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.gauge.bulletType', {
      defaultMessage: 'Bullet type'
    }),
    "data-test-subj": "lens-gauge-bullet-type",
    buttonSize: "compressed",
    options: bulletTypes,
    idSelected: selectedBulletType.id,
    onChange: optionId => {
      const newBulletTypeWithPrefix = bulletTypes.find(({
        id
      }) => id === optionId).id;
      const newBulletType = newBulletTypeWithPrefix.replace(PREFIX, '');
      setState({
        ...state,
        shape: newBulletType
      });
    }
  })));
};
const TitlesAndTextPopover = props => {
  var _frame$activeData, _frame$activeData$sta, _frame$activeData$sta2;
  const {
    state,
    setState,
    frame
  } = props;
  const metricDimensionTitle = state.layerId && ((_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : (_frame$activeData$sta = _frame$activeData[state.layerId]) === null || _frame$activeData$sta === void 0 ? void 0 : (_frame$activeData$sta2 = _frame$activeData$sta.columns.find(col => col.id === state.metricAccessor)) === null || _frame$activeData$sta2 === void 0 ? void 0 : _frame$activeData$sta2.name);
  const [subtitleMode, setSubtitleMode] = (0, _react.useState)(() => state.labelMinor ? 'custom' : 'none');
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: setState,
    value: state
  });
  return /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    handleClose: () => {
      setSubtitleMode(inputValue.labelMinor ? 'custom' : 'none');
    },
    title: _i18n.i18n.translate('xpack.lens.gauge.appearanceLabel', {
      defaultMessage: 'Titles and text'
    }),
    type: "titlesAndText",
    buttonDataTestSubj: "lnsTextOptionsButton",
    panelStyle: {
      width: '500px'
    },
    "data-test-subj": "lnsTextOptionsPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.gauge.labelMajor.header', {
      defaultMessage: 'Title'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_shared_components.VisLabel, {
    header: _i18n.i18n.translate('xpack.lens.label.gauge.labelMajor.header', {
      defaultMessage: 'Title'
    }),
    dataTestSubj: "lnsToolbarGaugeLabelMajor",
    label: inputValue.labelMajor || '',
    mode: inputValue.labelMajorMode,
    placeholder: metricDimensionTitle || '',
    hasAutoOption: true,
    handleChange: value => {
      handleInputChange({
        ...inputValue,
        labelMajor: value.label,
        labelMajorMode: value.mode
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.gauge.labelMinor.header', {
      defaultMessage: 'Subtitle'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_components.VisLabel, {
    header: _i18n.i18n.translate('xpack.lens.label.gauge.labelMinor.header', {
      defaultMessage: 'Subtitle'
    }),
    dataTestSubj: "lnsToolbarGaugeLabelMinor",
    label: inputValue.labelMinor || '',
    mode: subtitleMode,
    handleChange: value => {
      handleInputChange({
        ...inputValue,
        labelMinor: value.mode === 'none' ? '' : value.label
      });
      setSubtitleMode(value.mode);
    }
  })));
};