"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldType = getFieldType;
exports.getReferencedField = getReferencedField;
exports.hasField = hasField;
exports.normalizeOperationDataType = normalizeOperationDataType;
exports.shouldShowTimeSeriesOption = shouldShowTimeSeriesOption;
exports.sortByField = sortByField;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Normalizes the specified operation type. (e.g. document operations
 * produce 'number')
 */
function normalizeOperationDataType(type) {
  if (type === 'histogram') return 'number';
  return type === 'document' ? 'number' : type;
}
function hasField(column) {
  return 'sourceField' in column;
}
function shouldShowTimeSeriesOption(layer, indexPattern, groupId, dimensionGroups) {
  var _dimensionGroups$find;
  return Boolean(((_dimensionGroups$find = dimensionGroups.find(({
    groupId: id
  }) => groupId === id)) === null || _dimensionGroups$find === void 0 ? void 0 : _dimensionGroups$find.isBreakdownDimension) && containsColumnWithTimeSeriesMetric(layer, indexPattern));
}
function containsColumnWithTimeSeriesMetric(layer, indexPattern) {
  return Object.values(layer.columns).some(column => {
    var _indexPattern$getFiel;
    return hasField(column) && ((_indexPattern$getFiel = indexPattern.getFieldByName(column.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.timeSeriesMetric);
  });
}
function getFieldType(field) {
  if (field.timeSeriesMetric) {
    return field.timeSeriesMetric;
  }
  return field.type;
}
function getReferencedField(column, indexPattern, layer) {
  if (!column) return;
  if (!('references' in column)) return;
  const referencedColumn = layer.columns[column.references[0]];
  if (!referencedColumn || !hasField(referencedColumn)) return;
  return indexPattern.getFieldByName(referencedColumn.sourceField);
}
function sortByField(columns) {
  return [...columns].sort((column1, column2) => {
    if (hasField(column1) && hasField(column2)) {
      return column1.sourceField.localeCompare(column2.sourceField);
    }
    return column1.operationType.localeCompare(column2.operationType);
  });
}