"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedKeyValuePairs = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFlattenedKeyValuePairs = (item, parentKey) => {
  if (item) {
    const isArrayWithSingleValue = Array.isArray(item) && item.length === 1;
    return Object.keys(item).sort().reduce((acc, key) => {
      const childKey = isArrayWithSingleValue ? '' : key;
      const currentKey = (0, _lodash.compact)([parentKey, childKey]).join('.');
      // item[key] can be a primitive (string, number, boolean, null, undefined) or Object or Array
      // @ts-expect-error upgrade typescript v5.1.6
      if ((0, _lodash.isObject)(item[key])) {
        // @ts-expect-error upgrade typescript v5.1.6
        return acc.concat(getFlattenedKeyValuePairs(item[key], currentKey));
      } else {
        // @ts-expect-error upgrade typescript v5.1.6
        acc.push({
          key: currentKey,
          value: item[key]
        });
        return acc;
      }
    }, []);
  }
  return [];
};
exports.getFlattenedKeyValuePairs = getFlattenedKeyValuePairs;