"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenShardFailureFlyoutButton = OpenShardFailureFlyoutButton;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_failure_flyout = require("./shard_failure_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function OpenShardFailureFlyoutButton({
  failures
}) {
  const [showFailures, setShowFailures] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, failures.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    onClick: () => {
      setShowFailures(!showFailures);
    },
    size: "xs"
  }, _i18n.i18n.translate('inspector.requests.clusters.shards.openShardFailureFlyoutButtonLabel', {
    defaultMessage: 'View {failedShardCount} failed {failedShardCount, plural, one {shard} other {shards}}',
    values: {
      failedShardCount: failures.length
    }
  })) : null, showFailures ? /*#__PURE__*/_react.default.createElement(_shard_failure_flyout.ShardFailureFlyout, {
    failures: failures,
    onClose: () => {
      setShowFailures(false);
    }
  }) : null);
}