"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDepsMock = void 0;
var _react = _interopRequireDefault(require("react"));
var _get_search_service_mock = require("./get_search_service_mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fields = [];
fields.push({
  name: 'myField'
});
fields.getByName = name => {
  return fields.find(({
    name: n
  }) => n === name);
};
fields.getAll = () => [...fields];
const getDepsMock = ({
  searchSource = {
    create: (0, _get_search_service_mock.getSearchSourceMock)()
  }
} = {}) => ({
  core: {
    getStartServices: jest.fn().mockReturnValue([null, {
      data: {
        search: {
          searchSource
        },
        indexPatterns: {
          get: () => ({
            fields
          })
        }
      },
      unifiedSearch: {
        ui: {
          IndexPatternSelect: () => /*#__PURE__*/_react.default.createElement("div", null)
        }
      }
    }])
  },
  getSettings: jest.fn().mockImplementation(() => {
    return Promise.resolve({
      autocompleteTimeout: 1000,
      autocompleteTerminateAfter: 100000
    });
  }),
  data: {
    search: {
      searchSource: {
        create: (0, _get_search_service_mock.getSearchSourceMock)()
      }
    },
    query: {
      filterManager: {
        fieldName: 'myField',
        getIndexPattern: () => ({
          fields
        }),
        getAppFilters: jest.fn().mockImplementation(() => []),
        getGlobalFilters: jest.fn().mockImplementation(() => [])
      },
      timefilter: {
        timefilter: {}
      }
    }
  }
});
exports.getDepsMock = getDepsMock;