"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDatabaseModal = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../shared_imports");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteDatabaseModal = ({
  closeModal,
  database,
  reloadDatabases
}) => {
  const [confirmation, setConfirmation] = (0, _react.useState)('');
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isValid = confirmation === 'delete';
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const onDeleteDatabase = async event => {
    event.preventDefault();
    if (!isValid) {
      return;
    }
    setIsLoading(true);
    try {
      const {
        error
      } = await services.api.deleteDatabase(database.id);
      setIsLoading(false);
      if (error) {
        services.notifications.toasts.addError(error, {
          title: _constants.deleteDatabaseErrorTitle
        });
      } else {
        services.notifications.toasts.addSuccess((0, _constants.getDeleteDatabaseSuccessMessage)(database.name));
        await reloadDatabases();
        closeModal();
      }
    } catch (e) {
      setIsLoading(false);
      services.notifications.toasts.addError(e, {
        title: _constants.deleteDatabaseErrorTitle
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": _constants.DELETE_DATABASE_MODAL_TITLE_ID,
    onClose: closeModal,
    initialFocus: "[name=confirmation]"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: _constants.DELETE_DATABASE_MODAL_TITLE_ID
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.deleteDatabaseModalTitle",
    defaultMessage: "Delete {database}",
    values: {
      database: database.name
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: _constants.DELETE_DATABASE_MODAL_FORM_ID,
    component: "form",
    onSubmit: event => onDeleteDatabase(event)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.deleteDatabaseForm.confirmationLabel",
      defaultMessage: 'Please type "delete" to confirm.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "confirmation",
    value: confirmation,
    onChange: e => setConfirmation(e.target.value),
    "data-test-subj": "geoipDatabaseConfirmation"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.deleteModalCancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    form: _constants.DELETE_DATABASE_MODAL_FORM_ID,
    disabled: isLoading || !isValid,
    color: "danger",
    "data-test-subj": "deleteGeoipDatabaseSubmit"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.deleteModalConfirmButtonLabel",
    defaultMessage: "Delete"
  }))));
};
exports.DeleteDatabaseModal = DeleteDatabaseModal;